// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.subscription.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** The workload type of the subscription. It can be either Production or DevTest. */
public final class Workload extends ExpandableStringEnum<Workload> {
    /** Static value Production for Workload. */
    public static final Workload PRODUCTION = fromString("Production");

    /** Static value DevTest for Workload. */
    public static final Workload DEV_TEST = fromString("DevTest");

    /**
     * Creates a new instance of Workload value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public Workload() {
    }

    /**
     * Creates or finds a Workload from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding Workload.
     */
    @JsonCreator
    public static Workload fromString(String name) {
        return fromString(name, Workload.class);
    }

    /**
     * Gets known Workload values.
     *
     * @return known Workload values.
     */
    public static Collection<Workload> values() {
        return values(Workload.class);
    }
}
