/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.trafficmanager.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.trafficmanager.models.QueryExperience;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class TrafficFlow {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(TrafficFlow.class);
    @JsonProperty(value="sourceIp")
    private String sourceIp;
    @JsonProperty(value="latitude")
    private Double latitude;
    @JsonProperty(value="longitude")
    private Double longitude;
    @JsonProperty(value="queryExperiences")
    private List<QueryExperience> queryExperiences;

    public String sourceIp() {
        return this.sourceIp;
    }

    public TrafficFlow withSourceIp(String sourceIp) {
        this.sourceIp = sourceIp;
        return this;
    }

    public Double latitude() {
        return this.latitude;
    }

    public TrafficFlow withLatitude(Double latitude) {
        this.latitude = latitude;
        return this;
    }

    public Double longitude() {
        return this.longitude;
    }

    public TrafficFlow withLongitude(Double longitude) {
        this.longitude = longitude;
        return this;
    }

    public List<QueryExperience> queryExperiences() {
        return this.queryExperiences;
    }

    public TrafficFlow withQueryExperiences(List<QueryExperience> queryExperiences) {
        this.queryExperiences = queryExperiences;
        return this;
    }

    public void validate() {
        if (this.queryExperiences() != null) {
            this.queryExperiences().forEach(e -> e.validate());
        }
    }
}

