/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.trafficmanager.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.trafficmanager.fluent.GeographicHierarchiesClient;
import com.azure.resourcemanager.trafficmanager.fluent.models.TrafficManagerGeographicHierarchyInner;
import com.azure.resourcemanager.trafficmanager.implementation.TrafficManagerManagementClientImpl;
import reactor.core.publisher.Mono;

public final class GeographicHierarchiesClientImpl
implements GeographicHierarchiesClient {
    private final ClientLogger logger = new ClientLogger(GeographicHierarchiesClientImpl.class);
    private final GeographicHierarchiesService service;
    private final TrafficManagerManagementClientImpl client;

    GeographicHierarchiesClientImpl(TrafficManagerManagementClientImpl client) {
        this.service = (GeographicHierarchiesService)RestProxy.create(GeographicHierarchiesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TrafficManagerGeographicHierarchyInner>> getDefaultWithResponseAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDefault(this.client.getEndpoint(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<TrafficManagerGeographicHierarchyInner>> getDefaultWithResponseAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getDefault(this.client.getEndpoint(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TrafficManagerGeographicHierarchyInner> getDefaultAsync() {
        return this.getDefaultWithResponseAsync().flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((TrafficManagerGeographicHierarchyInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TrafficManagerGeographicHierarchyInner getDefault() {
        return (TrafficManagerGeographicHierarchyInner)((Object)this.getDefaultAsync().block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TrafficManagerGeographicHierarchyInner> getDefaultWithResponse(Context context) {
        return (Response)this.getDefaultWithResponseAsync(context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="TrafficManagerManage")
    private static interface GeographicHierarchiesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Network/trafficManagerGeographicHierarchies/default")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TrafficManagerGeographicHierarchyInner>> getDefault(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

