// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.trafficmanager.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.resourcemanager.trafficmanager.fluent.HeatMapsClient;
import com.azure.resourcemanager.trafficmanager.fluent.models.HeatMapModelInner;
import java.util.List;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in HeatMapsClient. */
public final class HeatMapsClientImpl implements HeatMapsClient {
    /** The proxy service used to perform REST calls. */
    private final HeatMapsService service;

    /** The service client containing this operation class. */
    private final TrafficManagerManagementClientImpl client;

    /**
     * Initializes an instance of HeatMapsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    HeatMapsClientImpl(TrafficManagerManagementClientImpl client) {
        this.service = RestProxy.create(HeatMapsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for TrafficManagerManagementClientHeatMaps to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "TrafficManagerManage")
    private interface HeatMapsService {
        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/trafficmanagerprofiles/{profileName}/heatMaps/{heatMapType}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<HeatMapModelInner>> get(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("profileName") String profileName,
            @PathParam("heatMapType") String heatMapType,
            @QueryParam("topLeft") String topLeft,
            @QueryParam("botRight") String botRight,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * Gets latest heatmap for Traffic Manager profile.
     *
     * @param resourceGroupName The name of the resource group containing the Traffic Manager endpoint.
     * @param profileName The name of the Traffic Manager profile.
     * @param topLeft The top left latitude,longitude pair of the rectangular viewport to query for.
     * @param botRight The bottom right latitude,longitude pair of the rectangular viewport to query for.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return latest heatmap for Traffic Manager profile along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<HeatMapModelInner>> getWithResponseAsync(
        String resourceGroupName, String profileName, List<Double> topLeft, List<Double> botRight) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        final String heatMapType = "default";
        final String accept = "application/json";
        String topLeftConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeIterable(topLeft, CollectionFormat.CSV);
        String botRightConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeIterable(botRight, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .get(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            profileName,
                            heatMapType,
                            topLeftConverted,
                            botRightConverted,
                            this.client.getApiVersion(),
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets latest heatmap for Traffic Manager profile.
     *
     * @param resourceGroupName The name of the resource group containing the Traffic Manager endpoint.
     * @param profileName The name of the Traffic Manager profile.
     * @param topLeft The top left latitude,longitude pair of the rectangular viewport to query for.
     * @param botRight The bottom right latitude,longitude pair of the rectangular viewport to query for.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return latest heatmap for Traffic Manager profile along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<HeatMapModelInner>> getWithResponseAsync(
        String resourceGroupName, String profileName, List<Double> topLeft, List<Double> botRight, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        final String heatMapType = "default";
        final String accept = "application/json";
        String topLeftConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeIterable(topLeft, CollectionFormat.CSV);
        String botRightConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeIterable(botRight, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .get(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                profileName,
                heatMapType,
                topLeftConverted,
                botRightConverted,
                this.client.getApiVersion(),
                accept,
                context);
    }

    /**
     * Gets latest heatmap for Traffic Manager profile.
     *
     * @param resourceGroupName The name of the resource group containing the Traffic Manager endpoint.
     * @param profileName The name of the Traffic Manager profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return latest heatmap for Traffic Manager profile on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<HeatMapModelInner> getAsync(String resourceGroupName, String profileName) {
        final List<Double> topLeft = null;
        final List<Double> botRight = null;
        return getWithResponseAsync(resourceGroupName, profileName, topLeft, botRight)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets latest heatmap for Traffic Manager profile.
     *
     * @param resourceGroupName The name of the resource group containing the Traffic Manager endpoint.
     * @param profileName The name of the Traffic Manager profile.
     * @param topLeft The top left latitude,longitude pair of the rectangular viewport to query for.
     * @param botRight The bottom right latitude,longitude pair of the rectangular viewport to query for.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return latest heatmap for Traffic Manager profile along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<HeatMapModelInner> getWithResponse(
        String resourceGroupName, String profileName, List<Double> topLeft, List<Double> botRight, Context context) {
        return getWithResponseAsync(resourceGroupName, profileName, topLeft, botRight, context).block();
    }

    /**
     * Gets latest heatmap for Traffic Manager profile.
     *
     * @param resourceGroupName The name of the resource group containing the Traffic Manager endpoint.
     * @param profileName The name of the Traffic Manager profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return latest heatmap for Traffic Manager profile.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public HeatMapModelInner get(String resourceGroupName, String profileName) {
        final List<Double> topLeft = null;
        final List<Double> botRight = null;
        return getWithResponse(resourceGroupName, profileName, topLeft, botRight, Context.NONE).getValue();
    }
}
