// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.trafficmanager.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.trafficmanager.models.AlwaysServe;
import com.azure.resourcemanager.trafficmanager.models.EndpointMonitorStatus;
import com.azure.resourcemanager.trafficmanager.models.EndpointPropertiesCustomHeadersItem;
import com.azure.resourcemanager.trafficmanager.models.EndpointPropertiesSubnetsItem;
import com.azure.resourcemanager.trafficmanager.models.EndpointStatus;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Class representing a Traffic Manager endpoint properties. */
@Fluent
public final class EndpointProperties {
    /*
     * The Azure Resource URI of the of the endpoint. Not applicable to endpoints of type 'ExternalEndpoints'.
     */
    @JsonProperty(value = "targetResourceId")
    private String targetResourceId;

    /*
     * The fully-qualified DNS name or IP address of the endpoint. Traffic Manager returns this value in DNS responses
     * to direct traffic to this endpoint.
     */
    @JsonProperty(value = "target")
    private String target;

    /*
     * The status of the endpoint. If the endpoint is Enabled, it is probed for endpoint health and is included in the
     * traffic routing method.
     */
    @JsonProperty(value = "endpointStatus")
    private EndpointStatus endpointStatus;

    /*
     * The weight of this endpoint when using the 'Weighted' traffic routing method. Possible values are from 1 to
     * 1000.
     */
    @JsonProperty(value = "weight")
    private Long weight;

    /*
     * The priority of this endpoint when using the 'Priority' traffic routing method. Possible values are from 1 to
     * 1000, lower values represent higher priority. This is an optional parameter.  If specified, it must be specified
     * on all endpoints, and no two endpoints can share the same priority value.
     */
    @JsonProperty(value = "priority")
    private Long priority;

    /*
     * Specifies the location of the external or nested endpoints when using the 'Performance' traffic routing method.
     */
    @JsonProperty(value = "endpointLocation")
    private String endpointLocation;

    /*
     * The monitoring status of the endpoint.
     */
    @JsonProperty(value = "endpointMonitorStatus")
    private EndpointMonitorStatus endpointMonitorStatus;

    /*
     * The minimum number of endpoints that must be available in the child profile in order for the parent profile to
     * be considered available. Only applicable to endpoint of type 'NestedEndpoints'.
     */
    @JsonProperty(value = "minChildEndpoints")
    private Long minChildEndpoints;

    /*
     * The minimum number of IPv4 (DNS record type A) endpoints that must be available in the child profile in order
     * for the parent profile to be considered available. Only applicable to endpoint of type 'NestedEndpoints'.
     */
    @JsonProperty(value = "minChildEndpointsIPv4")
    private Long minChildEndpointsIPv4;

    /*
     * The minimum number of IPv6 (DNS record type AAAA) endpoints that must be available in the child profile in order
     * for the parent profile to be considered available. Only applicable to endpoint of type 'NestedEndpoints'.
     */
    @JsonProperty(value = "minChildEndpointsIPv6")
    private Long minChildEndpointsIPv6;

    /*
     * The list of countries/regions mapped to this endpoint when using the 'Geographic' traffic routing method. Please
     * consult Traffic Manager Geographic documentation for a full list of accepted values.
     */
    @JsonProperty(value = "geoMapping")
    private List<String> geoMapping;

    /*
     * The list of subnets, IP addresses, and/or address ranges mapped to this endpoint when using the 'Subnet' traffic
     * routing method. An empty list will match all ranges not covered by other endpoints.
     */
    @JsonProperty(value = "subnets")
    private List<EndpointPropertiesSubnetsItem> subnets;

    /*
     * List of custom headers.
     */
    @JsonProperty(value = "customHeaders")
    private List<EndpointPropertiesCustomHeadersItem> customHeaders;

    /*
     * If Always Serve is enabled, probing for endpoint health will be disabled and endpoints will be included in the
     * traffic routing method.
     */
    @JsonProperty(value = "alwaysServe")
    private AlwaysServe alwaysServe;

    /** Creates an instance of EndpointProperties class. */
    public EndpointProperties() {
    }

    /**
     * Get the targetResourceId property: The Azure Resource URI of the of the endpoint. Not applicable to endpoints of
     * type 'ExternalEndpoints'.
     *
     * @return the targetResourceId value.
     */
    public String targetResourceId() {
        return this.targetResourceId;
    }

    /**
     * Set the targetResourceId property: The Azure Resource URI of the of the endpoint. Not applicable to endpoints of
     * type 'ExternalEndpoints'.
     *
     * @param targetResourceId the targetResourceId value to set.
     * @return the EndpointProperties object itself.
     */
    public EndpointProperties withTargetResourceId(String targetResourceId) {
        this.targetResourceId = targetResourceId;
        return this;
    }

    /**
     * Get the target property: The fully-qualified DNS name or IP address of the endpoint. Traffic Manager returns this
     * value in DNS responses to direct traffic to this endpoint.
     *
     * @return the target value.
     */
    public String target() {
        return this.target;
    }

    /**
     * Set the target property: The fully-qualified DNS name or IP address of the endpoint. Traffic Manager returns this
     * value in DNS responses to direct traffic to this endpoint.
     *
     * @param target the target value to set.
     * @return the EndpointProperties object itself.
     */
    public EndpointProperties withTarget(String target) {
        this.target = target;
        return this;
    }

    /**
     * Get the endpointStatus property: The status of the endpoint. If the endpoint is Enabled, it is probed for
     * endpoint health and is included in the traffic routing method.
     *
     * @return the endpointStatus value.
     */
    public EndpointStatus endpointStatus() {
        return this.endpointStatus;
    }

    /**
     * Set the endpointStatus property: The status of the endpoint. If the endpoint is Enabled, it is probed for
     * endpoint health and is included in the traffic routing method.
     *
     * @param endpointStatus the endpointStatus value to set.
     * @return the EndpointProperties object itself.
     */
    public EndpointProperties withEndpointStatus(EndpointStatus endpointStatus) {
        this.endpointStatus = endpointStatus;
        return this;
    }

    /**
     * Get the weight property: The weight of this endpoint when using the 'Weighted' traffic routing method. Possible
     * values are from 1 to 1000.
     *
     * @return the weight value.
     */
    public Long weight() {
        return this.weight;
    }

    /**
     * Set the weight property: The weight of this endpoint when using the 'Weighted' traffic routing method. Possible
     * values are from 1 to 1000.
     *
     * @param weight the weight value to set.
     * @return the EndpointProperties object itself.
     */
    public EndpointProperties withWeight(Long weight) {
        this.weight = weight;
        return this;
    }

    /**
     * Get the priority property: The priority of this endpoint when using the 'Priority' traffic routing method.
     * Possible values are from 1 to 1000, lower values represent higher priority. This is an optional parameter. If
     * specified, it must be specified on all endpoints, and no two endpoints can share the same priority value.
     *
     * @return the priority value.
     */
    public Long priority() {
        return this.priority;
    }

    /**
     * Set the priority property: The priority of this endpoint when using the 'Priority' traffic routing method.
     * Possible values are from 1 to 1000, lower values represent higher priority. This is an optional parameter. If
     * specified, it must be specified on all endpoints, and no two endpoints can share the same priority value.
     *
     * @param priority the priority value to set.
     * @return the EndpointProperties object itself.
     */
    public EndpointProperties withPriority(Long priority) {
        this.priority = priority;
        return this;
    }

    /**
     * Get the endpointLocation property: Specifies the location of the external or nested endpoints when using the
     * 'Performance' traffic routing method.
     *
     * @return the endpointLocation value.
     */
    public String endpointLocation() {
        return this.endpointLocation;
    }

    /**
     * Set the endpointLocation property: Specifies the location of the external or nested endpoints when using the
     * 'Performance' traffic routing method.
     *
     * @param endpointLocation the endpointLocation value to set.
     * @return the EndpointProperties object itself.
     */
    public EndpointProperties withEndpointLocation(String endpointLocation) {
        this.endpointLocation = endpointLocation;
        return this;
    }

    /**
     * Get the endpointMonitorStatus property: The monitoring status of the endpoint.
     *
     * @return the endpointMonitorStatus value.
     */
    public EndpointMonitorStatus endpointMonitorStatus() {
        return this.endpointMonitorStatus;
    }

    /**
     * Set the endpointMonitorStatus property: The monitoring status of the endpoint.
     *
     * @param endpointMonitorStatus the endpointMonitorStatus value to set.
     * @return the EndpointProperties object itself.
     */
    public EndpointProperties withEndpointMonitorStatus(EndpointMonitorStatus endpointMonitorStatus) {
        this.endpointMonitorStatus = endpointMonitorStatus;
        return this;
    }

    /**
     * Get the minChildEndpoints property: The minimum number of endpoints that must be available in the child profile
     * in order for the parent profile to be considered available. Only applicable to endpoint of type
     * 'NestedEndpoints'.
     *
     * @return the minChildEndpoints value.
     */
    public Long minChildEndpoints() {
        return this.minChildEndpoints;
    }

    /**
     * Set the minChildEndpoints property: The minimum number of endpoints that must be available in the child profile
     * in order for the parent profile to be considered available. Only applicable to endpoint of type
     * 'NestedEndpoints'.
     *
     * @param minChildEndpoints the minChildEndpoints value to set.
     * @return the EndpointProperties object itself.
     */
    public EndpointProperties withMinChildEndpoints(Long minChildEndpoints) {
        this.minChildEndpoints = minChildEndpoints;
        return this;
    }

    /**
     * Get the minChildEndpointsIPv4 property: The minimum number of IPv4 (DNS record type A) endpoints that must be
     * available in the child profile in order for the parent profile to be considered available. Only applicable to
     * endpoint of type 'NestedEndpoints'.
     *
     * @return the minChildEndpointsIPv4 value.
     */
    public Long minChildEndpointsIPv4() {
        return this.minChildEndpointsIPv4;
    }

    /**
     * Set the minChildEndpointsIPv4 property: The minimum number of IPv4 (DNS record type A) endpoints that must be
     * available in the child profile in order for the parent profile to be considered available. Only applicable to
     * endpoint of type 'NestedEndpoints'.
     *
     * @param minChildEndpointsIPv4 the minChildEndpointsIPv4 value to set.
     * @return the EndpointProperties object itself.
     */
    public EndpointProperties withMinChildEndpointsIPv4(Long minChildEndpointsIPv4) {
        this.minChildEndpointsIPv4 = minChildEndpointsIPv4;
        return this;
    }

    /**
     * Get the minChildEndpointsIPv6 property: The minimum number of IPv6 (DNS record type AAAA) endpoints that must be
     * available in the child profile in order for the parent profile to be considered available. Only applicable to
     * endpoint of type 'NestedEndpoints'.
     *
     * @return the minChildEndpointsIPv6 value.
     */
    public Long minChildEndpointsIPv6() {
        return this.minChildEndpointsIPv6;
    }

    /**
     * Set the minChildEndpointsIPv6 property: The minimum number of IPv6 (DNS record type AAAA) endpoints that must be
     * available in the child profile in order for the parent profile to be considered available. Only applicable to
     * endpoint of type 'NestedEndpoints'.
     *
     * @param minChildEndpointsIPv6 the minChildEndpointsIPv6 value to set.
     * @return the EndpointProperties object itself.
     */
    public EndpointProperties withMinChildEndpointsIPv6(Long minChildEndpointsIPv6) {
        this.minChildEndpointsIPv6 = minChildEndpointsIPv6;
        return this;
    }

    /**
     * Get the geoMapping property: The list of countries/regions mapped to this endpoint when using the 'Geographic'
     * traffic routing method. Please consult Traffic Manager Geographic documentation for a full list of accepted
     * values.
     *
     * @return the geoMapping value.
     */
    public List<String> geoMapping() {
        return this.geoMapping;
    }

    /**
     * Set the geoMapping property: The list of countries/regions mapped to this endpoint when using the 'Geographic'
     * traffic routing method. Please consult Traffic Manager Geographic documentation for a full list of accepted
     * values.
     *
     * @param geoMapping the geoMapping value to set.
     * @return the EndpointProperties object itself.
     */
    public EndpointProperties withGeoMapping(List<String> geoMapping) {
        this.geoMapping = geoMapping;
        return this;
    }

    /**
     * Get the subnets property: The list of subnets, IP addresses, and/or address ranges mapped to this endpoint when
     * using the 'Subnet' traffic routing method. An empty list will match all ranges not covered by other endpoints.
     *
     * @return the subnets value.
     */
    public List<EndpointPropertiesSubnetsItem> subnets() {
        return this.subnets;
    }

    /**
     * Set the subnets property: The list of subnets, IP addresses, and/or address ranges mapped to this endpoint when
     * using the 'Subnet' traffic routing method. An empty list will match all ranges not covered by other endpoints.
     *
     * @param subnets the subnets value to set.
     * @return the EndpointProperties object itself.
     */
    public EndpointProperties withSubnets(List<EndpointPropertiesSubnetsItem> subnets) {
        this.subnets = subnets;
        return this;
    }

    /**
     * Get the customHeaders property: List of custom headers.
     *
     * @return the customHeaders value.
     */
    public List<EndpointPropertiesCustomHeadersItem> customHeaders() {
        return this.customHeaders;
    }

    /**
     * Set the customHeaders property: List of custom headers.
     *
     * @param customHeaders the customHeaders value to set.
     * @return the EndpointProperties object itself.
     */
    public EndpointProperties withCustomHeaders(List<EndpointPropertiesCustomHeadersItem> customHeaders) {
        this.customHeaders = customHeaders;
        return this;
    }

    /**
     * Get the alwaysServe property: If Always Serve is enabled, probing for endpoint health will be disabled and
     * endpoints will be included in the traffic routing method.
     *
     * @return the alwaysServe value.
     */
    public AlwaysServe alwaysServe() {
        return this.alwaysServe;
    }

    /**
     * Set the alwaysServe property: If Always Serve is enabled, probing for endpoint health will be disabled and
     * endpoints will be included in the traffic routing method.
     *
     * @param alwaysServe the alwaysServe value to set.
     * @return the EndpointProperties object itself.
     */
    public EndpointProperties withAlwaysServe(AlwaysServe alwaysServe) {
        this.alwaysServe = alwaysServe;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (subnets() != null) {
            subnets().forEach(e -> e.validate());
        }
        if (customHeaders() != null) {
            customHeaders().forEach(e -> e.validate());
        }
    }
}
