// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.trafficmanager.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Custom header name and value.
 */
@Fluent
public final class MonitorConfigCustomHeadersItem implements JsonSerializable<MonitorConfigCustomHeadersItem> {
    /*
     * Header name.
     */
    private String name;

    /*
     * Header value.
     */
    private String value;

    /**
     * Creates an instance of MonitorConfigCustomHeadersItem class.
     */
    public MonitorConfigCustomHeadersItem() {
    }

    /**
     * Get the name property: Header name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Header name.
     * 
     * @param name the name value to set.
     * @return the MonitorConfigCustomHeadersItem object itself.
     */
    public MonitorConfigCustomHeadersItem withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the value property: Header value.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: Header value.
     * 
     * @param value the value value to set.
     * @return the MonitorConfigCustomHeadersItem object itself.
     */
    public MonitorConfigCustomHeadersItem withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MonitorConfigCustomHeadersItem from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MonitorConfigCustomHeadersItem if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MonitorConfigCustomHeadersItem.
     */
    public static MonitorConfigCustomHeadersItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MonitorConfigCustomHeadersItem deserializedMonitorConfigCustomHeadersItem
                = new MonitorConfigCustomHeadersItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedMonitorConfigCustomHeadersItem.name = reader.getString();
                } else if ("value".equals(fieldName)) {
                    deserializedMonitorConfigCustomHeadersItem.value = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMonitorConfigCustomHeadersItem;
        });
    }
}
