// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.trafficmanager.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.trafficmanager.models.Region;
import java.io.IOException;

/**
 * Class representing the Geographic hierarchy used with the Geographic traffic routing method.
 */
@Fluent
public final class TrafficManagerGeographicHierarchyInner extends ProxyResource {
    /*
     * The properties of the Geographic Hierarchy resource.
     */
    private GeographicHierarchyProperties innerProperties;

    /*
     * Fully qualified resource Id for the resource. Ex -
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/
     * trafficManagerProfiles/{resourceName}
     */
    private String id;

    /*
     * The name of the resource
     */
    private String name;

    /*
     * The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
     */
    private String type;

    /**
     * Creates an instance of TrafficManagerGeographicHierarchyInner class.
     */
    public TrafficManagerGeographicHierarchyInner() {
    }

    /**
     * Get the innerProperties property: The properties of the Geographic Hierarchy resource.
     * 
     * @return the innerProperties value.
     */
    private GeographicHierarchyProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource. Ex -
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Fully qualified resource Id for the resource. Ex -
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}.
     * 
     * @param id the id value to set.
     * @return the TrafficManagerGeographicHierarchyInner object itself.
     */
    public TrafficManagerGeographicHierarchyInner withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the resource.
     * 
     * @param name the name value to set.
     * @return the TrafficManagerGeographicHierarchyInner object itself.
     */
    public TrafficManagerGeographicHierarchyInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type property: The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
     * 
     * @param type the type value to set.
     * @return the TrafficManagerGeographicHierarchyInner object itself.
     */
    public TrafficManagerGeographicHierarchyInner withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the geographicHierarchy property: The region at the root of the hierarchy from all the regions in the
     * hierarchy can be retrieved.
     * 
     * @return the geographicHierarchy value.
     */
    public Region geographicHierarchy() {
        return this.innerProperties() == null ? null : this.innerProperties().geographicHierarchy();
    }

    /**
     * Set the geographicHierarchy property: The region at the root of the hierarchy from all the regions in the
     * hierarchy can be retrieved.
     * 
     * @param geographicHierarchy the geographicHierarchy value to set.
     * @return the TrafficManagerGeographicHierarchyInner object itself.
     */
    public TrafficManagerGeographicHierarchyInner withGeographicHierarchy(Region geographicHierarchy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GeographicHierarchyProperties();
        }
        this.innerProperties().withGeographicHierarchy(geographicHierarchy);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TrafficManagerGeographicHierarchyInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TrafficManagerGeographicHierarchyInner if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the TrafficManagerGeographicHierarchyInner.
     */
    public static TrafficManagerGeographicHierarchyInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TrafficManagerGeographicHierarchyInner deserializedTrafficManagerGeographicHierarchyInner
                = new TrafficManagerGeographicHierarchyInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedTrafficManagerGeographicHierarchyInner.innerProperties
                        = GeographicHierarchyProperties.fromJson(reader);
                } else if ("id".equals(fieldName)) {
                    deserializedTrafficManagerGeographicHierarchyInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedTrafficManagerGeographicHierarchyInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedTrafficManagerGeographicHierarchyInner.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTrafficManagerGeographicHierarchyInner;
        });
    }
}
