// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.trafficmanager.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import com.azure.resourcemanager.trafficmanager.fluent.ProfilesClient;
import com.azure.resourcemanager.trafficmanager.fluent.models.DeleteOperationResultInner;
import com.azure.resourcemanager.trafficmanager.fluent.models.ProfileInner;
import com.azure.resourcemanager.trafficmanager.fluent.models.TrafficManagerNameAvailabilityInner;
import com.azure.resourcemanager.trafficmanager.models.CheckTrafficManagerRelativeDnsNameAvailabilityParameters;
import com.azure.resourcemanager.trafficmanager.models.ProfileListResult;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in ProfilesClient. */
public final class ProfilesClientImpl
    implements InnerSupportsGet<ProfileInner>,
        InnerSupportsListing<ProfileInner>,
        InnerSupportsDelete<DeleteOperationResultInner>,
        ProfilesClient {
    private final ClientLogger logger = new ClientLogger(ProfilesClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final ProfilesService service;

    /** The service client containing this operation class. */
    private final TrafficManagerManagementClientImpl client;

    /**
     * Initializes an instance of ProfilesClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    ProfilesClientImpl(TrafficManagerManagementClientImpl client) {
        this.service = RestProxy.create(ProfilesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for TrafficManagerManagementClientProfiles to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "TrafficManagerManage")
    private interface ProfilesService {
        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Post("/providers/Microsoft.Network/checkTrafficManagerNameAvailability")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<TrafficManagerNameAvailabilityInner>> checkTrafficManagerRelativeDnsNameAvailability(
            @HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") CheckTrafficManagerRelativeDnsNameAvailabilityParameters parameters,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/trafficmanagerprofiles")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ProfileListResult>> listByResourceGroup(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Network/trafficmanagerprofiles")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ProfileListResult>> list(
            @HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/trafficmanagerprofiles/{profileName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ProfileInner>> getByResourceGroup(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("profileName") String profileName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Put(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/trafficmanagerprofiles/{profileName}")
        @ExpectedResponses({200, 201})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ProfileInner>> createOrUpdate(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("profileName") String profileName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") ProfileInner parameters,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Delete(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/trafficmanagerprofiles/{profileName}")
        @ExpectedResponses({200, 204})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DeleteOperationResultInner>> delete(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("profileName") String profileName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Patch(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network"
                + "/trafficmanagerprofiles/{profileName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ProfileInner>> update(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("profileName") String profileName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") ProfileInner parameters,
            Context context);
    }

    /**
     * Checks the availability of a Traffic Manager Relative DNS name.
     *
     * @param parameters Parameters supplied to check Traffic Manager name operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a Traffic Manager Name Availability response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<TrafficManagerNameAvailabilityInner>>
        checkTrafficManagerRelativeDnsNameAvailabilityWithResponseAsync(
            CheckTrafficManagerRelativeDnsNameAvailabilityParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .checkTrafficManagerRelativeDnsNameAvailability(
                            this.client.getEndpoint(), this.client.getApiVersion(), parameters, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Checks the availability of a Traffic Manager Relative DNS name.
     *
     * @param parameters Parameters supplied to check Traffic Manager name operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a Traffic Manager Name Availability response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<TrafficManagerNameAvailabilityInner>>
        checkTrafficManagerRelativeDnsNameAvailabilityWithResponseAsync(
            CheckTrafficManagerRelativeDnsNameAvailabilityParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        context = this.client.mergeContext(context);
        return service
            .checkTrafficManagerRelativeDnsNameAvailability(
                this.client.getEndpoint(), this.client.getApiVersion(), parameters, context);
    }

    /**
     * Checks the availability of a Traffic Manager Relative DNS name.
     *
     * @param parameters Parameters supplied to check Traffic Manager name operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a Traffic Manager Name Availability response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<TrafficManagerNameAvailabilityInner> checkTrafficManagerRelativeDnsNameAvailabilityAsync(
        CheckTrafficManagerRelativeDnsNameAvailabilityParameters parameters) {
        return checkTrafficManagerRelativeDnsNameAvailabilityWithResponseAsync(parameters)
            .flatMap(
                (Response<TrafficManagerNameAvailabilityInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Checks the availability of a Traffic Manager Relative DNS name.
     *
     * @param parameters Parameters supplied to check Traffic Manager name operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a Traffic Manager Name Availability response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public TrafficManagerNameAvailabilityInner checkTrafficManagerRelativeDnsNameAvailability(
        CheckTrafficManagerRelativeDnsNameAvailabilityParameters parameters) {
        return checkTrafficManagerRelativeDnsNameAvailabilityAsync(parameters).block();
    }

    /**
     * Checks the availability of a Traffic Manager Relative DNS name.
     *
     * @param parameters Parameters supplied to check Traffic Manager name operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a Traffic Manager Name Availability response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<TrafficManagerNameAvailabilityInner> checkTrafficManagerRelativeDnsNameAvailabilityWithResponse(
        CheckTrafficManagerRelativeDnsNameAvailabilityParameters parameters, Context context) {
        return checkTrafficManagerRelativeDnsNameAvailabilityWithResponseAsync(parameters, context).block();
    }

    /**
     * Lists all Traffic Manager profiles within a resource group.
     *
     * @param resourceGroupName The name of the resource group containing the Traffic Manager profiles to be listed.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list Traffic Manager profiles operation response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ProfileInner>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listByResourceGroup(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            context))
            .<PagedResponse<ProfileInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Lists all Traffic Manager profiles within a resource group.
     *
     * @param resourceGroupName The name of the resource group containing the Traffic Manager profiles to be listed.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list Traffic Manager profiles operation response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ProfileInner>> listByResourceGroupSinglePageAsync(
        String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listByResourceGroup(
                this.client.getEndpoint(),
                resourceGroupName,
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null));
    }

    /**
     * Lists all Traffic Manager profiles within a resource group.
     *
     * @param resourceGroupName The name of the resource group containing the Traffic Manager profiles to be listed.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list Traffic Manager profiles operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ProfileInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux<>(() -> listByResourceGroupSinglePageAsync(resourceGroupName));
    }

    /**
     * Lists all Traffic Manager profiles within a resource group.
     *
     * @param resourceGroupName The name of the resource group containing the Traffic Manager profiles to be listed.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list Traffic Manager profiles operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ProfileInner> listByResourceGroupAsync(String resourceGroupName, Context context) {
        return new PagedFlux<>(() -> listByResourceGroupSinglePageAsync(resourceGroupName, context));
    }

    /**
     * Lists all Traffic Manager profiles within a resource group.
     *
     * @param resourceGroupName The name of the resource group containing the Traffic Manager profiles to be listed.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list Traffic Manager profiles operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ProfileInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName));
    }

    /**
     * Lists all Traffic Manager profiles within a resource group.
     *
     * @param resourceGroupName The name of the resource group containing the Traffic Manager profiles to be listed.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list Traffic Manager profiles operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ProfileInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName, context));
    }

    /**
     * Lists all Traffic Manager profiles within a subscription.
     *
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list Traffic Manager profiles operation response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ProfileInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .list(
                            this.client.getEndpoint(),
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            context))
            .<PagedResponse<ProfileInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Lists all Traffic Manager profiles within a subscription.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list Traffic Manager profiles operation response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ProfileInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null));
    }

    /**
     * Lists all Traffic Manager profiles within a subscription.
     *
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list Traffic Manager profiles operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ProfileInner> listAsync() {
        return new PagedFlux<>(() -> listSinglePageAsync());
    }

    /**
     * Lists all Traffic Manager profiles within a subscription.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list Traffic Manager profiles operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ProfileInner> listAsync(Context context) {
        return new PagedFlux<>(() -> listSinglePageAsync(context));
    }

    /**
     * Lists all Traffic Manager profiles within a subscription.
     *
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list Traffic Manager profiles operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ProfileInner> list() {
        return new PagedIterable<>(listAsync());
    }

    /**
     * Lists all Traffic Manager profiles within a subscription.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list Traffic Manager profiles operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ProfileInner> list(Context context) {
        return new PagedIterable<>(listAsync(context));
    }

    /**
     * Gets a Traffic Manager profile.
     *
     * @param resourceGroupName The name of the resource group containing the Traffic Manager profile.
     * @param profileName The name of the Traffic Manager profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Traffic Manager profile.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ProfileInner>> getByResourceGroupWithResponseAsync(
        String resourceGroupName, String profileName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getByResourceGroup(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            profileName,
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Gets a Traffic Manager profile.
     *
     * @param resourceGroupName The name of the resource group containing the Traffic Manager profile.
     * @param profileName The name of the Traffic Manager profile.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Traffic Manager profile.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ProfileInner>> getByResourceGroupWithResponseAsync(
        String resourceGroupName, String profileName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .getByResourceGroup(
                this.client.getEndpoint(),
                resourceGroupName,
                profileName,
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                context);
    }

    /**
     * Gets a Traffic Manager profile.
     *
     * @param resourceGroupName The name of the resource group containing the Traffic Manager profile.
     * @param profileName The name of the Traffic Manager profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Traffic Manager profile.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ProfileInner> getByResourceGroupAsync(String resourceGroupName, String profileName) {
        return getByResourceGroupWithResponseAsync(resourceGroupName, profileName)
            .flatMap(
                (Response<ProfileInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Gets a Traffic Manager profile.
     *
     * @param resourceGroupName The name of the resource group containing the Traffic Manager profile.
     * @param profileName The name of the Traffic Manager profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Traffic Manager profile.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ProfileInner getByResourceGroup(String resourceGroupName, String profileName) {
        return getByResourceGroupAsync(resourceGroupName, profileName).block();
    }

    /**
     * Gets a Traffic Manager profile.
     *
     * @param resourceGroupName The name of the resource group containing the Traffic Manager profile.
     * @param profileName The name of the Traffic Manager profile.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Traffic Manager profile.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ProfileInner> getByResourceGroupWithResponse(
        String resourceGroupName, String profileName, Context context) {
        return getByResourceGroupWithResponseAsync(resourceGroupName, profileName, context).block();
    }

    /**
     * Create or update a Traffic Manager profile.
     *
     * @param resourceGroupName The name of the resource group containing the Traffic Manager profile.
     * @param profileName The name of the Traffic Manager profile.
     * @param parameters Class representing a Traffic Manager profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a Traffic Manager profile.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ProfileInner>> createOrUpdateWithResponseAsync(
        String resourceGroupName, String profileName, ProfileInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .createOrUpdate(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            profileName,
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            parameters,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Create or update a Traffic Manager profile.
     *
     * @param resourceGroupName The name of the resource group containing the Traffic Manager profile.
     * @param profileName The name of the Traffic Manager profile.
     * @param parameters Class representing a Traffic Manager profile.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a Traffic Manager profile.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ProfileInner>> createOrUpdateWithResponseAsync(
        String resourceGroupName, String profileName, ProfileInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        context = this.client.mergeContext(context);
        return service
            .createOrUpdate(
                this.client.getEndpoint(),
                resourceGroupName,
                profileName,
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                parameters,
                context);
    }

    /**
     * Create or update a Traffic Manager profile.
     *
     * @param resourceGroupName The name of the resource group containing the Traffic Manager profile.
     * @param profileName The name of the Traffic Manager profile.
     * @param parameters Class representing a Traffic Manager profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a Traffic Manager profile.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ProfileInner> createOrUpdateAsync(
        String resourceGroupName, String profileName, ProfileInner parameters) {
        return createOrUpdateWithResponseAsync(resourceGroupName, profileName, parameters)
            .flatMap(
                (Response<ProfileInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Create or update a Traffic Manager profile.
     *
     * @param resourceGroupName The name of the resource group containing the Traffic Manager profile.
     * @param profileName The name of the Traffic Manager profile.
     * @param parameters Class representing a Traffic Manager profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a Traffic Manager profile.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ProfileInner createOrUpdate(String resourceGroupName, String profileName, ProfileInner parameters) {
        return createOrUpdateAsync(resourceGroupName, profileName, parameters).block();
    }

    /**
     * Create or update a Traffic Manager profile.
     *
     * @param resourceGroupName The name of the resource group containing the Traffic Manager profile.
     * @param profileName The name of the Traffic Manager profile.
     * @param parameters Class representing a Traffic Manager profile.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a Traffic Manager profile.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ProfileInner> createOrUpdateWithResponse(
        String resourceGroupName, String profileName, ProfileInner parameters, Context context) {
        return createOrUpdateWithResponseAsync(resourceGroupName, profileName, parameters, context).block();
    }

    /**
     * Deletes a Traffic Manager profile.
     *
     * @param resourceGroupName The name of the resource group containing the Traffic Manager profile to be deleted.
     * @param profileName The name of the Traffic Manager profile to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of the request or operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DeleteOperationResultInner>> deleteWithResponseAsync(
        String resourceGroupName, String profileName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .delete(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            profileName,
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Deletes a Traffic Manager profile.
     *
     * @param resourceGroupName The name of the resource group containing the Traffic Manager profile to be deleted.
     * @param profileName The name of the Traffic Manager profile to be deleted.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of the request or operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DeleteOperationResultInner>> deleteWithResponseAsync(
        String resourceGroupName, String profileName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .delete(
                this.client.getEndpoint(),
                resourceGroupName,
                profileName,
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                context);
    }

    /**
     * Deletes a Traffic Manager profile.
     *
     * @param resourceGroupName The name of the resource group containing the Traffic Manager profile to be deleted.
     * @param profileName The name of the Traffic Manager profile to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of the request or operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeleteOperationResultInner> deleteAsync(String resourceGroupName, String profileName) {
        return deleteWithResponseAsync(resourceGroupName, profileName)
            .flatMap(
                (Response<DeleteOperationResultInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Deletes a Traffic Manager profile.
     *
     * @param resourceGroupName The name of the resource group containing the Traffic Manager profile to be deleted.
     * @param profileName The name of the Traffic Manager profile to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of the request or operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeleteOperationResultInner delete(String resourceGroupName, String profileName) {
        return deleteAsync(resourceGroupName, profileName).block();
    }

    /**
     * Deletes a Traffic Manager profile.
     *
     * @param resourceGroupName The name of the resource group containing the Traffic Manager profile to be deleted.
     * @param profileName The name of the Traffic Manager profile to be deleted.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of the request or operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DeleteOperationResultInner> deleteWithResponse(
        String resourceGroupName, String profileName, Context context) {
        return deleteWithResponseAsync(resourceGroupName, profileName, context).block();
    }

    /**
     * Update a Traffic Manager profile.
     *
     * @param resourceGroupName The name of the resource group containing the Traffic Manager profile.
     * @param profileName The name of the Traffic Manager profile.
     * @param parameters Class representing a Traffic Manager profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a Traffic Manager profile.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ProfileInner>> updateWithResponseAsync(
        String resourceGroupName, String profileName, ProfileInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .update(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            profileName,
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            parameters,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Update a Traffic Manager profile.
     *
     * @param resourceGroupName The name of the resource group containing the Traffic Manager profile.
     * @param profileName The name of the Traffic Manager profile.
     * @param parameters Class representing a Traffic Manager profile.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a Traffic Manager profile.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ProfileInner>> updateWithResponseAsync(
        String resourceGroupName, String profileName, ProfileInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        context = this.client.mergeContext(context);
        return service
            .update(
                this.client.getEndpoint(),
                resourceGroupName,
                profileName,
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                parameters,
                context);
    }

    /**
     * Update a Traffic Manager profile.
     *
     * @param resourceGroupName The name of the resource group containing the Traffic Manager profile.
     * @param profileName The name of the Traffic Manager profile.
     * @param parameters Class representing a Traffic Manager profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a Traffic Manager profile.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ProfileInner> updateAsync(String resourceGroupName, String profileName, ProfileInner parameters) {
        return updateWithResponseAsync(resourceGroupName, profileName, parameters)
            .flatMap(
                (Response<ProfileInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Update a Traffic Manager profile.
     *
     * @param resourceGroupName The name of the resource group containing the Traffic Manager profile.
     * @param profileName The name of the Traffic Manager profile.
     * @param parameters Class representing a Traffic Manager profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a Traffic Manager profile.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ProfileInner update(String resourceGroupName, String profileName, ProfileInner parameters) {
        return updateAsync(resourceGroupName, profileName, parameters).block();
    }

    /**
     * Update a Traffic Manager profile.
     *
     * @param resourceGroupName The name of the resource group containing the Traffic Manager profile.
     * @param profileName The name of the Traffic Manager profile.
     * @param parameters Class representing a Traffic Manager profile.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing a Traffic Manager profile.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ProfileInner> updateWithResponse(
        String resourceGroupName, String profileName, ProfileInner parameters, Context context) {
        return updateWithResponseAsync(resourceGroupName, profileName, parameters, context).block();
    }
}
