// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.trafficmanager.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for EndpointMonitorStatus. */
public final class EndpointMonitorStatus extends ExpandableStringEnum<EndpointMonitorStatus> {
    /** Static value CheckingEndpoint for EndpointMonitorStatus. */
    public static final EndpointMonitorStatus CHECKING_ENDPOINT = fromString("CheckingEndpoint");

    /** Static value Online for EndpointMonitorStatus. */
    public static final EndpointMonitorStatus ONLINE = fromString("Online");

    /** Static value Degraded for EndpointMonitorStatus. */
    public static final EndpointMonitorStatus DEGRADED = fromString("Degraded");

    /** Static value Disabled for EndpointMonitorStatus. */
    public static final EndpointMonitorStatus DISABLED = fromString("Disabled");

    /** Static value Inactive for EndpointMonitorStatus. */
    public static final EndpointMonitorStatus INACTIVE = fromString("Inactive");

    /** Static value Stopped for EndpointMonitorStatus. */
    public static final EndpointMonitorStatus STOPPED = fromString("Stopped");

    /**
     * Creates or finds a EndpointMonitorStatus from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding EndpointMonitorStatus.
     */
    @JsonCreator
    public static EndpointMonitorStatus fromString(String name) {
        return fromString(name, EndpointMonitorStatus.class);
    }

    /** @return known EndpointMonitorStatus values. */
    public static Collection<EndpointMonitorStatus> values() {
        return values(EndpointMonitorStatus.class);
    }
}
