// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.trafficmanager.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Class representing a Traffic Manager Real User Metrics key response.
 */
@Fluent
public final class UserMetricsProperties implements JsonSerializable<UserMetricsProperties> {
    /*
     * The key returned by the User Metrics operation.
     */
    private String key;

    /**
     * Creates an instance of UserMetricsProperties class.
     */
    public UserMetricsProperties() {
    }

    /**
     * Get the key property: The key returned by the User Metrics operation.
     * 
     * @return the key value.
     */
    public String key() {
        return this.key;
    }

    /**
     * Set the key property: The key returned by the User Metrics operation.
     * 
     * @param key the key value to set.
     * @return the UserMetricsProperties object itself.
     */
    public UserMetricsProperties withKey(String key) {
        this.key = key;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("key", this.key);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UserMetricsProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UserMetricsProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the UserMetricsProperties.
     */
    public static UserMetricsProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UserMetricsProperties deserializedUserMetricsProperties = new UserMetricsProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("key".equals(fieldName)) {
                    deserializedUserMetricsProperties.key = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUserMetricsProperties;
        });
    }
}
