// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.trafficmanager.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Parameters supplied to check Traffic Manager name operation.
 */
@Fluent
public final class CheckTrafficManagerRelativeDnsNameAvailabilityParameters
    implements JsonSerializable<CheckTrafficManagerRelativeDnsNameAvailabilityParameters> {
    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of CheckTrafficManagerRelativeDnsNameAvailabilityParameters class.
     */
    public CheckTrafficManagerRelativeDnsNameAvailabilityParameters() {
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the resource.
     * 
     * @param name the name value to set.
     * @return the CheckTrafficManagerRelativeDnsNameAvailabilityParameters object itself.
     */
    public CheckTrafficManagerRelativeDnsNameAvailabilityParameters withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: The type of the resource.
     * 
     * @param type the type value to set.
     * @return the CheckTrafficManagerRelativeDnsNameAvailabilityParameters object itself.
     */
    public CheckTrafficManagerRelativeDnsNameAvailabilityParameters withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CheckTrafficManagerRelativeDnsNameAvailabilityParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CheckTrafficManagerRelativeDnsNameAvailabilityParameters if the JsonReader was pointing to
     * an instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the
     * CheckTrafficManagerRelativeDnsNameAvailabilityParameters.
     */
    public static CheckTrafficManagerRelativeDnsNameAvailabilityParameters fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            CheckTrafficManagerRelativeDnsNameAvailabilityParameters deserializedCheckTrafficManagerRelativeDnsNameAvailabilityParameters
                = new CheckTrafficManagerRelativeDnsNameAvailabilityParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedCheckTrafficManagerRelativeDnsNameAvailabilityParameters.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedCheckTrafficManagerRelativeDnsNameAvailabilityParameters.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCheckTrafficManagerRelativeDnsNameAvailabilityParameters;
        });
    }
}
