// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.trafficmanager.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.trafficmanager.models.AlwaysServe;
import com.azure.resourcemanager.trafficmanager.models.EndpointMonitorStatus;
import com.azure.resourcemanager.trafficmanager.models.EndpointPropertiesCustomHeadersItem;
import com.azure.resourcemanager.trafficmanager.models.EndpointPropertiesSubnetsItem;
import com.azure.resourcemanager.trafficmanager.models.EndpointStatus;
import java.io.IOException;
import java.util.List;

/**
 * Class representing a Traffic Manager endpoint.
 */
@Fluent
public final class EndpointInner extends ProxyResource {
    /*
     * The properties of the Traffic Manager endpoint.
     */
    private EndpointProperties innerProperties;

    /*
     * Fully qualified resource Id for the resource. Ex -
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/
     * trafficManagerProfiles/{resourceName}
     */
    private String id;

    /*
     * The name of the resource
     */
    private String name;

    /*
     * The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
     */
    private String type;

    /**
     * Creates an instance of EndpointInner class.
     */
    public EndpointInner() {
    }

    /**
     * Get the innerProperties property: The properties of the Traffic Manager endpoint.
     * 
     * @return the innerProperties value.
     */
    private EndpointProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource. Ex -
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Fully qualified resource Id for the resource. Ex -
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}.
     * 
     * @param id the id value to set.
     * @return the EndpointInner object itself.
     */
    public EndpointInner withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the resource.
     * 
     * @param name the name value to set.
     * @return the EndpointInner object itself.
     */
    public EndpointInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type property: The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
     * 
     * @param type the type value to set.
     * @return the EndpointInner object itself.
     */
    public EndpointInner withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the targetResourceId property: The Azure Resource URI of the of the endpoint. Not applicable to endpoints of
     * type 'ExternalEndpoints'.
     * 
     * @return the targetResourceId value.
     */
    public String targetResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().targetResourceId();
    }

    /**
     * Set the targetResourceId property: The Azure Resource URI of the of the endpoint. Not applicable to endpoints of
     * type 'ExternalEndpoints'.
     * 
     * @param targetResourceId the targetResourceId value to set.
     * @return the EndpointInner object itself.
     */
    public EndpointInner withTargetResourceId(String targetResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointProperties();
        }
        this.innerProperties().withTargetResourceId(targetResourceId);
        return this;
    }

    /**
     * Get the target property: The fully-qualified DNS name or IP address of the endpoint. Traffic Manager returns this
     * value in DNS responses to direct traffic to this endpoint.
     * 
     * @return the target value.
     */
    public String target() {
        return this.innerProperties() == null ? null : this.innerProperties().target();
    }

    /**
     * Set the target property: The fully-qualified DNS name or IP address of the endpoint. Traffic Manager returns this
     * value in DNS responses to direct traffic to this endpoint.
     * 
     * @param target the target value to set.
     * @return the EndpointInner object itself.
     */
    public EndpointInner withTarget(String target) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointProperties();
        }
        this.innerProperties().withTarget(target);
        return this;
    }

    /**
     * Get the endpointStatus property: The status of the endpoint. If the endpoint is Enabled, it is probed for
     * endpoint health and is included in the traffic routing method.
     * 
     * @return the endpointStatus value.
     */
    public EndpointStatus endpointStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().endpointStatus();
    }

    /**
     * Set the endpointStatus property: The status of the endpoint. If the endpoint is Enabled, it is probed for
     * endpoint health and is included in the traffic routing method.
     * 
     * @param endpointStatus the endpointStatus value to set.
     * @return the EndpointInner object itself.
     */
    public EndpointInner withEndpointStatus(EndpointStatus endpointStatus) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointProperties();
        }
        this.innerProperties().withEndpointStatus(endpointStatus);
        return this;
    }

    /**
     * Get the weight property: The weight of this endpoint when using the 'Weighted' traffic routing method. Possible
     * values are from 1 to 1000.
     * 
     * @return the weight value.
     */
    public Long weight() {
        return this.innerProperties() == null ? null : this.innerProperties().weight();
    }

    /**
     * Set the weight property: The weight of this endpoint when using the 'Weighted' traffic routing method. Possible
     * values are from 1 to 1000.
     * 
     * @param weight the weight value to set.
     * @return the EndpointInner object itself.
     */
    public EndpointInner withWeight(Long weight) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointProperties();
        }
        this.innerProperties().withWeight(weight);
        return this;
    }

    /**
     * Get the priority property: The priority of this endpoint when using the 'Priority' traffic routing method.
     * Possible values are from 1 to 1000, lower values represent higher priority. This is an optional parameter. If
     * specified, it must be specified on all endpoints, and no two endpoints can share the same priority value.
     * 
     * @return the priority value.
     */
    public Long priority() {
        return this.innerProperties() == null ? null : this.innerProperties().priority();
    }

    /**
     * Set the priority property: The priority of this endpoint when using the 'Priority' traffic routing method.
     * Possible values are from 1 to 1000, lower values represent higher priority. This is an optional parameter. If
     * specified, it must be specified on all endpoints, and no two endpoints can share the same priority value.
     * 
     * @param priority the priority value to set.
     * @return the EndpointInner object itself.
     */
    public EndpointInner withPriority(Long priority) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointProperties();
        }
        this.innerProperties().withPriority(priority);
        return this;
    }

    /**
     * Get the endpointLocation property: Specifies the location of the external or nested endpoints when using the
     * 'Performance' traffic routing method.
     * 
     * @return the endpointLocation value.
     */
    public String endpointLocation() {
        return this.innerProperties() == null ? null : this.innerProperties().endpointLocation();
    }

    /**
     * Set the endpointLocation property: Specifies the location of the external or nested endpoints when using the
     * 'Performance' traffic routing method.
     * 
     * @param endpointLocation the endpointLocation value to set.
     * @return the EndpointInner object itself.
     */
    public EndpointInner withEndpointLocation(String endpointLocation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointProperties();
        }
        this.innerProperties().withEndpointLocation(endpointLocation);
        return this;
    }

    /**
     * Get the endpointMonitorStatus property: The monitoring status of the endpoint.
     * 
     * @return the endpointMonitorStatus value.
     */
    public EndpointMonitorStatus endpointMonitorStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().endpointMonitorStatus();
    }

    /**
     * Set the endpointMonitorStatus property: The monitoring status of the endpoint.
     * 
     * @param endpointMonitorStatus the endpointMonitorStatus value to set.
     * @return the EndpointInner object itself.
     */
    public EndpointInner withEndpointMonitorStatus(EndpointMonitorStatus endpointMonitorStatus) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointProperties();
        }
        this.innerProperties().withEndpointMonitorStatus(endpointMonitorStatus);
        return this;
    }

    /**
     * Get the minChildEndpoints property: The minimum number of endpoints that must be available in the child profile
     * in order for the parent profile to be considered available. Only applicable to endpoint of type
     * 'NestedEndpoints'.
     * 
     * @return the minChildEndpoints value.
     */
    public Long minChildEndpoints() {
        return this.innerProperties() == null ? null : this.innerProperties().minChildEndpoints();
    }

    /**
     * Set the minChildEndpoints property: The minimum number of endpoints that must be available in the child profile
     * in order for the parent profile to be considered available. Only applicable to endpoint of type
     * 'NestedEndpoints'.
     * 
     * @param minChildEndpoints the minChildEndpoints value to set.
     * @return the EndpointInner object itself.
     */
    public EndpointInner withMinChildEndpoints(Long minChildEndpoints) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointProperties();
        }
        this.innerProperties().withMinChildEndpoints(minChildEndpoints);
        return this;
    }

    /**
     * Get the minChildEndpointsIPv4 property: The minimum number of IPv4 (DNS record type A) endpoints that must be
     * available in the child profile in order for the parent profile to be considered available. Only applicable to
     * endpoint of type 'NestedEndpoints'.
     * 
     * @return the minChildEndpointsIPv4 value.
     */
    public Long minChildEndpointsIPv4() {
        return this.innerProperties() == null ? null : this.innerProperties().minChildEndpointsIPv4();
    }

    /**
     * Set the minChildEndpointsIPv4 property: The minimum number of IPv4 (DNS record type A) endpoints that must be
     * available in the child profile in order for the parent profile to be considered available. Only applicable to
     * endpoint of type 'NestedEndpoints'.
     * 
     * @param minChildEndpointsIPv4 the minChildEndpointsIPv4 value to set.
     * @return the EndpointInner object itself.
     */
    public EndpointInner withMinChildEndpointsIPv4(Long minChildEndpointsIPv4) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointProperties();
        }
        this.innerProperties().withMinChildEndpointsIPv4(minChildEndpointsIPv4);
        return this;
    }

    /**
     * Get the minChildEndpointsIPv6 property: The minimum number of IPv6 (DNS record type AAAA) endpoints that must be
     * available in the child profile in order for the parent profile to be considered available. Only applicable to
     * endpoint of type 'NestedEndpoints'.
     * 
     * @return the minChildEndpointsIPv6 value.
     */
    public Long minChildEndpointsIPv6() {
        return this.innerProperties() == null ? null : this.innerProperties().minChildEndpointsIPv6();
    }

    /**
     * Set the minChildEndpointsIPv6 property: The minimum number of IPv6 (DNS record type AAAA) endpoints that must be
     * available in the child profile in order for the parent profile to be considered available. Only applicable to
     * endpoint of type 'NestedEndpoints'.
     * 
     * @param minChildEndpointsIPv6 the minChildEndpointsIPv6 value to set.
     * @return the EndpointInner object itself.
     */
    public EndpointInner withMinChildEndpointsIPv6(Long minChildEndpointsIPv6) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointProperties();
        }
        this.innerProperties().withMinChildEndpointsIPv6(minChildEndpointsIPv6);
        return this;
    }

    /**
     * Get the geoMapping property: The list of countries/regions mapped to this endpoint when using the 'Geographic'
     * traffic routing method. Please consult Traffic Manager Geographic documentation for a full list of accepted
     * values.
     * 
     * @return the geoMapping value.
     */
    public List<String> geoMapping() {
        return this.innerProperties() == null ? null : this.innerProperties().geoMapping();
    }

    /**
     * Set the geoMapping property: The list of countries/regions mapped to this endpoint when using the 'Geographic'
     * traffic routing method. Please consult Traffic Manager Geographic documentation for a full list of accepted
     * values.
     * 
     * @param geoMapping the geoMapping value to set.
     * @return the EndpointInner object itself.
     */
    public EndpointInner withGeoMapping(List<String> geoMapping) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointProperties();
        }
        this.innerProperties().withGeoMapping(geoMapping);
        return this;
    }

    /**
     * Get the subnets property: The list of subnets, IP addresses, and/or address ranges mapped to this endpoint when
     * using the 'Subnet' traffic routing method. An empty list will match all ranges not covered by other endpoints.
     * 
     * @return the subnets value.
     */
    public List<EndpointPropertiesSubnetsItem> subnets() {
        return this.innerProperties() == null ? null : this.innerProperties().subnets();
    }

    /**
     * Set the subnets property: The list of subnets, IP addresses, and/or address ranges mapped to this endpoint when
     * using the 'Subnet' traffic routing method. An empty list will match all ranges not covered by other endpoints.
     * 
     * @param subnets the subnets value to set.
     * @return the EndpointInner object itself.
     */
    public EndpointInner withSubnets(List<EndpointPropertiesSubnetsItem> subnets) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointProperties();
        }
        this.innerProperties().withSubnets(subnets);
        return this;
    }

    /**
     * Get the customHeaders property: List of custom headers.
     * 
     * @return the customHeaders value.
     */
    public List<EndpointPropertiesCustomHeadersItem> customHeaders() {
        return this.innerProperties() == null ? null : this.innerProperties().customHeaders();
    }

    /**
     * Set the customHeaders property: List of custom headers.
     * 
     * @param customHeaders the customHeaders value to set.
     * @return the EndpointInner object itself.
     */
    public EndpointInner withCustomHeaders(List<EndpointPropertiesCustomHeadersItem> customHeaders) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointProperties();
        }
        this.innerProperties().withCustomHeaders(customHeaders);
        return this;
    }

    /**
     * Get the alwaysServe property: If Always Serve is enabled, probing for endpoint health will be disabled and
     * endpoints will be included in the traffic routing method.
     * 
     * @return the alwaysServe value.
     */
    public AlwaysServe alwaysServe() {
        return this.innerProperties() == null ? null : this.innerProperties().alwaysServe();
    }

    /**
     * Set the alwaysServe property: If Always Serve is enabled, probing for endpoint health will be disabled and
     * endpoints will be included in the traffic routing method.
     * 
     * @param alwaysServe the alwaysServe value to set.
     * @return the EndpointInner object itself.
     */
    public EndpointInner withAlwaysServe(AlwaysServe alwaysServe) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EndpointProperties();
        }
        this.innerProperties().withAlwaysServe(alwaysServe);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EndpointInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EndpointInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the EndpointInner.
     */
    public static EndpointInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EndpointInner deserializedEndpointInner = new EndpointInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedEndpointInner.innerProperties = EndpointProperties.fromJson(reader);
                } else if ("id".equals(fieldName)) {
                    deserializedEndpointInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedEndpointInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedEndpointInner.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEndpointInner;
        });
    }
}
