// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.trafficmanager.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Min and max value of a status code range.
 */
@Fluent
public final class MonitorConfigExpectedStatusCodeRangesItem
    implements JsonSerializable<MonitorConfigExpectedStatusCodeRangesItem> {
    /*
     * Min status code.
     */
    private Integer min;

    /*
     * Max status code.
     */
    private Integer max;

    /**
     * Creates an instance of MonitorConfigExpectedStatusCodeRangesItem class.
     */
    public MonitorConfigExpectedStatusCodeRangesItem() {
    }

    /**
     * Get the min property: Min status code.
     * 
     * @return the min value.
     */
    public Integer min() {
        return this.min;
    }

    /**
     * Set the min property: Min status code.
     * 
     * @param min the min value to set.
     * @return the MonitorConfigExpectedStatusCodeRangesItem object itself.
     */
    public MonitorConfigExpectedStatusCodeRangesItem withMin(Integer min) {
        this.min = min;
        return this;
    }

    /**
     * Get the max property: Max status code.
     * 
     * @return the max value.
     */
    public Integer max() {
        return this.max;
    }

    /**
     * Set the max property: Max status code.
     * 
     * @param max the max value to set.
     * @return the MonitorConfigExpectedStatusCodeRangesItem object itself.
     */
    public MonitorConfigExpectedStatusCodeRangesItem withMax(Integer max) {
        this.max = max;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("min", this.min);
        jsonWriter.writeNumberField("max", this.max);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MonitorConfigExpectedStatusCodeRangesItem from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MonitorConfigExpectedStatusCodeRangesItem if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MonitorConfigExpectedStatusCodeRangesItem.
     */
    public static MonitorConfigExpectedStatusCodeRangesItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MonitorConfigExpectedStatusCodeRangesItem deserializedMonitorConfigExpectedStatusCodeRangesItem
                = new MonitorConfigExpectedStatusCodeRangesItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("min".equals(fieldName)) {
                    deserializedMonitorConfigExpectedStatusCodeRangesItem.min = reader.getNullable(JsonReader::getInt);
                } else if ("max".equals(fieldName)) {
                    deserializedMonitorConfigExpectedStatusCodeRangesItem.max = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMonitorConfigExpectedStatusCodeRangesItem;
        });
    }
}
