// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.trafficmanager.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.trafficmanager.fluent.models.DeleteOperationResultInner;
import com.azure.resourcemanager.trafficmanager.fluent.models.UserMetricsModelInner;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in TrafficManagerUserMetricsKeysClient. */
public interface TrafficManagerUserMetricsKeysClient {
    /**
     * Get the subscription-level key used for Real User Metrics collection.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the subscription-level key used for Real User Metrics collection.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<UserMetricsModelInner>> getWithResponseAsync();

    /**
     * Get the subscription-level key used for Real User Metrics collection.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the subscription-level key used for Real User Metrics collection.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<UserMetricsModelInner> getAsync();

    /**
     * Get the subscription-level key used for Real User Metrics collection.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the subscription-level key used for Real User Metrics collection.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    UserMetricsModelInner get();

    /**
     * Get the subscription-level key used for Real User Metrics collection.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the subscription-level key used for Real User Metrics collection.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<UserMetricsModelInner> getWithResponse(Context context);

    /**
     * Create or update a subscription-level key used for Real User Metrics collection.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Traffic Manager User Metrics.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<UserMetricsModelInner>> createOrUpdateWithResponseAsync();

    /**
     * Create or update a subscription-level key used for Real User Metrics collection.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Traffic Manager User Metrics.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<UserMetricsModelInner> createOrUpdateAsync();

    /**
     * Create or update a subscription-level key used for Real User Metrics collection.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Traffic Manager User Metrics.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    UserMetricsModelInner createOrUpdate();

    /**
     * Create or update a subscription-level key used for Real User Metrics collection.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return class representing Traffic Manager User Metrics.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<UserMetricsModelInner> createOrUpdateWithResponse(Context context);

    /**
     * Delete a subscription-level key used for Real User Metrics collection.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of the request or operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DeleteOperationResultInner>> deleteWithResponseAsync();

    /**
     * Delete a subscription-level key used for Real User Metrics collection.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of the request or operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DeleteOperationResultInner> deleteAsync();

    /**
     * Delete a subscription-level key used for Real User Metrics collection.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of the request or operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeleteOperationResultInner delete();

    /**
     * Delete a subscription-level key used for Real User Metrics collection.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of the request or operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DeleteOperationResultInner> deleteWithResponse(Context context);
}
