/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.security.keyvault.certificates.starter;

import com.azure.security.keyvault.jca.KeyVaultJcaProvider;
import com.azure.security.keyvault.jca.KeyVaultTrustManagerFactoryProvider;
import java.security.Provider;
import java.security.Security;
import java.util.Optional;
import java.util.Properties;
import javax.net.ssl.HttpsURLConnection;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

@Order
public class KeyVaultCertificatesEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        Properties properties;
        this.putEnvironmentPropertyToSystemProperty(environment, "azure.keyvault.uri");
        this.putEnvironmentPropertyToSystemProperty(environment, "azure.keyvault.tenant-id");
        this.putEnvironmentPropertyToSystemProperty(environment, "azure.keyvault.client-id");
        this.putEnvironmentPropertyToSystemProperty(environment, "azure.keyvault.client-secret");
        this.putEnvironmentPropertyToSystemProperty(environment, "azure.keyvault.managed-identity");
        this.putEnvironmentPropertyToSystemProperty(environment, "azure.keyvault.jca.certificates-refresh-interval");
        this.putEnvironmentPropertyToSystemProperty(environment, "azure.keyvault.jca.certificates-refresh-interval-in-ms");
        this.putEnvironmentPropertyToSystemProperty(environment, "azure.keyvault.jca.refresh-certificates-when-have-un-trust-certificate");
        this.putEnvironmentPropertyToSystemProperty(environment, "azure.cert-path.well-known");
        this.putEnvironmentPropertyToSystemProperty(environment, "azure.cert-path.custom");
        MutablePropertySources propertySources = environment.getPropertySources();
        if ("AzureKeyVault".equals(environment.getProperty("server.ssl.key-store-type"))) {
            properties = new Properties();
            properties.put("server.ssl.key-store", "classpath:keyvault.dummy");
            if (this.hasEmbedTomcat()) {
                properties.put("server.ssl.key-store-type", "DKS");
            }
            propertySources.addFirst((PropertySource)new PropertiesPropertySource("KeyStorePropertySource", properties));
        }
        if ("AzureKeyVault".equals(environment.getProperty("server.ssl.trust-store-type"))) {
            properties = new Properties();
            properties.put("server.ssl.trust-store", "classpath:keyvault.dummy");
            if (this.hasEmbedTomcat()) {
                properties.put("server.ssl.trust-store-type", "DKS");
            }
            propertySources.addFirst((PropertySource)new PropertiesPropertySource("TrustStorePropertySource", properties));
        }
        Security.removeProvider("AzureKeyVault");
        Security.insertProviderAt((Provider)new KeyVaultJcaProvider(), 1);
        if (KeyVaultCertificatesEnvironmentPostProcessor.overrideTrustManagerFactory(environment)) {
            Security.insertProviderAt((Provider)new KeyVaultTrustManagerFactoryProvider(), 1);
        }
        if (KeyVaultCertificatesEnvironmentPostProcessor.disableHostnameVerification(environment)) {
            HttpsURLConnection.setDefaultHostnameVerifier((hostname, session) -> true);
        }
    }

    private void putEnvironmentPropertyToSystemProperty(ConfigurableEnvironment environment, String key) {
        Optional.of(key).map(arg_0 -> ((ConfigurableEnvironment)environment).getProperty(arg_0)).filter(StringUtils::hasText).ifPresent(value -> System.getProperties().put(key, value));
    }

    private boolean hasEmbedTomcat() {
        try {
            Class.forName("org.apache.tomcat.InstanceManager");
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    static boolean overrideTrustManagerFactory(ConfigurableEnvironment environment) {
        return KeyVaultCertificatesEnvironmentPostProcessor.environmentPropertyIsTrue(environment, "azure.keyvault.jca.overrideTrustManagerFactory") || KeyVaultCertificatesEnvironmentPostProcessor.environmentPropertyIsTrue(environment, "azure.keyvault.jca.override-trust-manager-factory");
    }

    private static boolean disableHostnameVerification(ConfigurableEnvironment environment) {
        return KeyVaultCertificatesEnvironmentPostProcessor.environmentPropertyIsTrue(environment, "azure.keyvault.jca.disableHostnameVerification") || KeyVaultCertificatesEnvironmentPostProcessor.environmentPropertyIsTrue(environment, "azure.keyvault.jca.disable-hostname-verification");
    }

    private static boolean environmentPropertyIsTrue(ConfigurableEnvironment environment, String key) {
        return Optional.of(key).map(arg_0 -> ((ConfigurableEnvironment)environment).getProperty(arg_0)).map(Boolean::parseBoolean).orElse(false);
    }
}

