/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.aad;

import com.azure.spring.aad.webapp.AzureClientRegistration;
import com.azure.spring.autoconfigure.aad.AADAuthenticationProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;

public abstract class AADClientRegistrationRepository
implements ClientRegistrationRepository {
    public static final String AZURE_CLIENT_REGISTRATION_ID = "azure";
    protected final AzureClientRegistration azureClient;
    protected final List<ClientRegistration> otherClients;
    protected final Map<String, ClientRegistration> allClients;
    protected final AADAuthenticationProperties properties;

    public AADClientRegistrationRepository(AzureClientRegistration azureClient, List<ClientRegistration> otherClients, AADAuthenticationProperties properties) {
        this.azureClient = azureClient;
        this.otherClients = new ArrayList<ClientRegistration>(otherClients);
        this.properties = properties;
        this.allClients = new HashMap<String, ClientRegistration>();
        this.addClientRegistration(azureClient.getClient());
        for (ClientRegistration c : otherClients) {
            this.addClientRegistration(c);
        }
    }

    private void addClientRegistration(ClientRegistration client) {
        this.allClients.put(client.getRegistrationId(), client);
    }

    public ClientRegistration findByRegistrationId(String registrationId) {
        return this.allClients.get(registrationId);
    }

    public AzureClientRegistration getAzureClient() {
        return this.azureClient;
    }

    public boolean isClientNeedConsentWhenLogin(ClientRegistration client) {
        return this.otherClients.contains(client) && this.properties.getAuthorizationClients().get(client.getClientName()) != null && !this.properties.getAuthorizationClients().get(client.getClientName()).isOnDemand();
    }

    public boolean isClientNeedConsentWhenLogin(String id) {
        ClientRegistration client = this.findByRegistrationId(id);
        return client != null && this.isClientNeedConsentWhenLogin(client);
    }

    public static boolean isDefaultClient(ClientRegistration clientRegistration) {
        return AZURE_CLIENT_REGISTRATION_ID.equals(clientRegistration.getClientName());
    }

    public static boolean isDefaultClient(String clientId) {
        return AZURE_CLIENT_REGISTRATION_ID.equals(clientId);
    }
}

