/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.aad.webapi;

import com.azure.spring.aad.AADAuthorizationServerEndpoints;
import com.azure.spring.aad.webapi.AADOAuth2OboAuthorizedClientRepository;
import com.azure.spring.aad.webapp.AuthorizationClientProperties;
import com.azure.spring.autoconfigure.aad.AADAuthenticationProperties;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.OAuth2LoginAuthenticationFilter;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.server.resource.BearerTokenAuthenticationToken;

@Configuration(proxyBeanMethods=false)
@ConditionalOnResource(resources={"classpath:aad.enable.config"})
@EnableConfigurationProperties(value={AADAuthenticationProperties.class})
@ConditionalOnClass(value={BearerTokenAuthenticationToken.class, OAuth2LoginAuthenticationFilter.class})
@ConditionalOnProperty(prefix="azure.activedirectory", value={"client-id"})
public class AADResourceServerOboConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(AADResourceServerOboConfiguration.class);
    @Autowired
    private AADAuthenticationProperties properties;

    @Bean
    @ConditionalOnMissingBean(value={ClientRegistrationRepository.class})
    public ClientRegistrationRepository clientRegistrationRepository() {
        List<ClientRegistration> oboClients = this.createOboClients();
        if (oboClients.isEmpty()) {
            LOGGER.warn("No client registrations are found for AAD Obo.");
            return registrationId -> null;
        }
        return new InMemoryClientRegistrationRepository(oboClients);
    }

    @Bean
    @ConditionalOnMissingBean
    public OAuth2AuthorizedClientRepository oAuth2AuthorizedClientRepository(ClientRegistrationRepository repo) {
        return new AADOAuth2OboAuthorizedClientRepository(repo);
    }

    public List<ClientRegistration> createOboClients() {
        ArrayList<ClientRegistration> result = new ArrayList<ClientRegistration>();
        for (String name : this.properties.getAuthorizationClients().keySet()) {
            AuthorizationClientProperties authorizationProperties = this.properties.getAuthorizationClients().get(name);
            ClientRegistration.Builder builder = this.createClientBuilder(name);
            builder.scope(authorizationProperties.getScopes());
            result.add(builder.build());
        }
        return result;
    }

    private ClientRegistration.Builder createClientBuilder(String id) {
        ClientRegistration.Builder result = ClientRegistration.withRegistrationId((String)id);
        result.authorizationGrantType(AuthorizationGrantType.REFRESH_TOKEN);
        result.redirectUriTemplate("{baseUrl}/login/oauth2/code/{registrationId}");
        result.clientId(this.properties.getClientId());
        result.clientSecret(this.properties.getClientSecret());
        AADAuthorizationServerEndpoints endpoints = new AADAuthorizationServerEndpoints(this.properties.getBaseUri(), this.properties.getTenantId());
        result.authorizationUri(endpoints.authorizationEndpoint());
        return result;
    }
}

