/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.aad.webapp;

import com.azure.spring.aad.webapp.GraphClient;
import com.azure.spring.autoconfigure.aad.AADAuthenticationProperties;
import com.azure.spring.autoconfigure.aad.Constants;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpSession;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserRequest;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.core.AbstractOAuth2Token;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class AADOAuth2UserService
implements OAuth2UserService<OidcUserRequest, OidcUser> {
    private final OidcUserService oidcUserService;
    private final AADAuthenticationProperties properties;
    private final GraphClient graphClient;
    private static final String DEFAULT_OIDC_USER = "defaultOidcUser";

    public AADOAuth2UserService(AADAuthenticationProperties properties) {
        this.properties = properties;
        this.oidcUserService = new OidcUserService();
        this.graphClient = new GraphClient(properties);
    }

    public OidcUser loadUser(OidcUserRequest userRequest) throws OAuth2AuthenticationException {
        OidcUser oidcUser = this.oidcUserService.loadUser(userRequest);
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        ServletRequestAttributes attr = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpSession session = attr.getRequest().getSession(true);
        if (authentication != null) {
            return (DefaultOidcUser)session.getAttribute(DEFAULT_OIDC_USER);
        }
        Set groups = Optional.of(userRequest).filter(notUsed -> this.properties.allowedGroupsConfigured()).map(OAuth2UserRequest::getAccessToken).map(AbstractOAuth2Token::getTokenValue).map(this.graphClient::getGroupsFromGraph).orElseGet(Collections::emptySet);
        Set groupRoles = groups.stream().filter(this.properties::isAllowedGroup).map(group -> "ROLE_" + group).collect(Collectors.toSet());
        Set<Object> authorities = groupRoles.stream().map(SimpleGrantedAuthority::new).collect(Collectors.toSet());
        if (authorities.isEmpty()) {
            authorities = Constants.DEFAULT_AUTHORITY_SET;
        }
        String nameAttributeKey = Optional.of(userRequest).map(OAuth2UserRequest::getClientRegistration).map(ClientRegistration::getProviderDetails).map(ClientRegistration.ProviderDetails::getUserInfoEndpoint).map(ClientRegistration.ProviderDetails.UserInfoEndpoint::getUserNameAttributeName).filter(StringUtils::hasText).orElse("name");
        DefaultOidcUser defaultOidcUser = new DefaultOidcUser(authorities, oidcUser.getIdToken(), nameAttributeKey);
        session.setAttribute(DEFAULT_OIDC_USER, (Object)defaultOidcUser);
        return defaultOidcUser;
    }
}

