/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.autoconfigure.aad;

import com.azure.spring.aad.AADAuthorizationServerEndpoints;
import com.azure.spring.autoconfigure.aad.AADAuthenticationProperties;
import com.azure.spring.autoconfigure.aad.Constants;
import com.azure.spring.autoconfigure.aad.JacksonObjectMapperFactory;
import com.azure.spring.autoconfigure.aad.Membership;
import com.azure.spring.autoconfigure.aad.Memberships;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IClientCredential;
import com.microsoft.aad.msal4j.IClientSecret;
import com.microsoft.aad.msal4j.MsalServiceException;
import com.microsoft.aad.msal4j.OnBehalfOfParameters;
import com.microsoft.aad.msal4j.UserAssertion;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.naming.ServiceUnavailableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class AzureADGraphClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureADGraphClient.class);
    private static final String MICROSOFT_GRAPH_SCOPE = "https://graph.microsoft.com/user.read";
    private static final String REQUEST_ID_SUFFIX = "aadfeed6";
    private final String clientId;
    private final String clientSecret;
    private final AADAuthorizationServerEndpoints endpoints;
    private final AADAuthenticationProperties aadAuthenticationProperties;

    public AzureADGraphClient(String clientId, String clientSecret, AADAuthenticationProperties aadAuthenticationProperties, AADAuthorizationServerEndpoints endpoints) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.aadAuthenticationProperties = aadAuthenticationProperties;
        this.endpoints = endpoints;
    }

    private String getUserMemberships(String accessToken, String urlString) throws IOException {
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(HttpMethod.GET.toString());
        connection.setRequestProperty("Authorization", String.format("Bearer %s", accessToken));
        connection.setRequestProperty("Accept", "application/json");
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        String responseInJson = AzureADGraphClient.getResponseString(connection);
        int responseCode = connection.getResponseCode();
        if (responseCode == 200) {
            return responseInJson;
        }
        throw new IllegalStateException("Response is not 200, response json: " + responseInJson);
    }

    private static String getResponseString(HttpURLConnection connection) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            StringBuilder stringBuffer = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                stringBuffer.append(line);
            }
            String string = stringBuffer.toString();
            return string;
        }
    }

    public Set<String> getGroups(String graphApiToken) throws IOException {
        LinkedHashSet<String> groups = new LinkedHashSet<String>();
        ObjectMapper objectMapper = JacksonObjectMapperFactory.getInstance();
        String aadMembershipRestUri = this.aadAuthenticationProperties.getGraphMembershipUri();
        while (aadMembershipRestUri != null) {
            String membershipsJson = this.getUserMemberships(graphApiToken, aadMembershipRestUri);
            Memberships memberships = (Memberships)objectMapper.readValue(membershipsJson, Memberships.class);
            memberships.getValue().stream().filter(this::isGroupObject).map(Membership::getDisplayName).forEach(groups::add);
            aadMembershipRestUri = Optional.of(memberships).map(Memberships::getOdataNextLink).orElse(null);
        }
        return groups;
    }

    private boolean isGroupObject(Membership membership) {
        return membership.getObjectType().equals("#microsoft.graph.group");
    }

    public Set<SimpleGrantedAuthority> toGrantedAuthoritySet(Set<String> groups) {
        Set grantedAuthoritySet = groups.stream().filter(this.aadAuthenticationProperties::isAllowedGroup).map(group -> new SimpleGrantedAuthority("ROLE_" + group)).collect(Collectors.toSet());
        return Optional.of(grantedAuthoritySet).filter(g -> !g.isEmpty()).orElse(Constants.DEFAULT_AUTHORITY_SET);
    }

    public IAuthenticationResult acquireTokenForGraphApi(String idToken, String tenantId) throws ServiceUnavailableException {
        IClientSecret clientCredential = ClientCredentialFactory.createFromSecret((String)this.clientSecret);
        UserAssertion assertion = new UserAssertion(idToken);
        IAuthenticationResult result = null;
        try {
            ConfidentialClientApplication application = ((ConfidentialClientApplication.Builder)((ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)this.clientId, (IClientCredential)clientCredential).authority(this.endpoints.getBaseUri() + tenantId + "/")).correlationId(AzureADGraphClient.getCorrelationId())).build();
            HashSet<String> scopes = new HashSet<String>();
            scopes.add(MICROSOFT_GRAPH_SCOPE);
            OnBehalfOfParameters onBehalfOfParameters = OnBehalfOfParameters.builder(scopes, (UserAssertion)assertion).build();
            result = (IAuthenticationResult)application.acquireToken(onBehalfOfParameters).get();
        }
        catch (InterruptedException | MalformedURLException | ExecutionException e) {
            MsalServiceException exception;
            Throwable cause = e.getCause();
            if (cause instanceof MsalServiceException && (exception = (MsalServiceException)cause).claims() != null && !exception.claims().isEmpty()) {
                throw exception;
            }
            LOGGER.error("acquire on behalf of token for graph api error", (Throwable)e);
        }
        if (result == null) {
            throw new ServiceUnavailableException("unable to acquire on-behalf-of token for client " + this.clientId);
        }
        return result;
    }

    private static String getCorrelationId() {
        String uuid = UUID.randomUUID().toString();
        return uuid.substring(0, uuid.length() - REQUEST_ID_SUFFIX.length()) + REQUEST_ID_SUFFIX;
    }
}

