/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.aad.webapi;

import com.nimbusds.jwt.JWTClaimsSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.util.Assert;

public class AADOAuth2AuthenticatedPrincipal
implements OAuth2AuthenticatedPrincipal,
Serializable {
    private static final long serialVersionUID = -3625690847771476854L;
    private static final String PERSONAL_ACCOUNT_TENANT_ID = "9188040d-6c67-4c5b-b112-36a304b66dad";
    private final Collection<GrantedAuthority> authorities;
    private final Map<String, Object> headers;
    private final Map<String, Object> attributes;
    private final String tokenValue;
    private JWTClaimsSet jwtClaimsSet;

    public AADOAuth2AuthenticatedPrincipal(Map<String, Object> headers, Map<String, Object> attributes, Collection<GrantedAuthority> authorities, String tokenValue) {
        Assert.notEmpty(attributes, (String)"attributes cannot be empty");
        Assert.notEmpty(headers, (String)"headers cannot be empty");
        this.headers = headers;
        this.tokenValue = tokenValue;
        this.attributes = Collections.unmodifiableMap(attributes);
        this.authorities = authorities == null ? AuthorityUtils.NO_AUTHORITIES : Collections.unmodifiableCollection(authorities);
        this.toJwtClaimsSet(attributes);
    }

    private void toJwtClaimsSet(Map<String, Object> attributes) {
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder();
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            builder.claim(entry.getKey(), entry.getValue());
        }
        this.jwtClaimsSet = builder.build();
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public String getName() {
        return this.jwtClaimsSet == null ? null : (String)this.jwtClaimsSet.getClaim("name");
    }

    public String getTokenValue() {
        return this.tokenValue;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public JWTClaimsSet getJwtClaimsSet() {
        return this.jwtClaimsSet;
    }

    public String getIssuer() {
        return this.jwtClaimsSet == null ? null : this.jwtClaimsSet.getIssuer();
    }

    public String getSubject() {
        return this.jwtClaimsSet == null ? null : this.jwtClaimsSet.getSubject();
    }

    public Map<String, Object> getClaims() {
        return this.jwtClaimsSet == null ? null : this.jwtClaimsSet.getClaims();
    }

    public Object getClaim(String name) {
        return this.jwtClaimsSet == null ? null : this.jwtClaimsSet.getClaim(name);
    }

    public String getTenantId() {
        return this.jwtClaimsSet == null ? null : (String)this.jwtClaimsSet.getClaim("tid");
    }

    public boolean isPersonalAccount() {
        return PERSONAL_ACCOUNT_TENANT_ID.equals(this.getTenantId());
    }
}

