/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.aad.webapp;

import com.azure.spring.aad.webapp.AADOAuth2Error;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.savedrequest.DefaultSavedRequest;

public class AADAuthenticationFailureHandler
implements AuthenticationFailureHandler {
    private static final String DEFAULT_FAILURE_URL = "/login?error";
    private final AuthenticationFailureHandler defaultHandler = new SimpleUrlAuthenticationFailureHandler("/login?error");

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        String claims = Optional.of(exception).filter(e -> e instanceof OAuth2AuthenticationException).map(e -> (OAuth2AuthenticationException)e).map(OAuth2AuthenticationException::getError).filter(e -> e instanceof AADOAuth2Error).map(e -> (AADOAuth2Error)((Object)e)).map(AADOAuth2Error::getClaims).orElse(null);
        if (claims == null) {
            this.defaultHandler.onAuthenticationFailure(request, response, exception);
        } else {
            response.setStatus(302);
            request.getSession().setAttribute("CONDITIONAL_ACCESS_POLICY_CLAIMS", (Object)claims);
            String redirectUrl = Optional.of(request).map(HttpServletRequest::getSession).map(s -> s.getAttribute("SPRING_SECURITY_SAVED_REQUEST")).map(r -> (DefaultSavedRequest)r).map(DefaultSavedRequest::getRedirectUrl).orElse(null);
            response.sendRedirect(redirectUrl);
        }
    }
}

