/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.aad.webapp;

import com.azure.spring.aad.webapp.AzureClientRegistration;
import com.azure.spring.utils.ApplicationId;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.RequestEntity;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequest;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequestEntityConverter;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;

public class AADOAuth2AuthorizationCodeGrantRequestEntityConverter
extends OAuth2AuthorizationCodeGrantRequestEntityConverter {
    private final AzureClientRegistration azureClient;

    public AADOAuth2AuthorizationCodeGrantRequestEntityConverter(AzureClientRegistration client) {
        this.azureClient = client;
    }

    public RequestEntity<?> convert(OAuth2AuthorizationCodeGrantRequest request) {
        RequestEntity requestEntity = super.convert(request);
        Assert.notNull((Object)requestEntity, (String)"requestEntity can not be null");
        HttpHeaders httpHeaders = AADOAuth2AuthorizationCodeGrantRequestEntityConverter.getHttpHeaders();
        Optional.of(requestEntity).map(HttpEntity::getHeaders).ifPresent(headers -> headers.forEach((arg_0, arg_1) -> ((HttpHeaders)httpHeaders).put(arg_0, arg_1)));
        MultiValueMap body = (MultiValueMap)requestEntity.getBody();
        Assert.notNull((Object)body, (String)"body can not be null");
        String scopes = String.join((CharSequence)" ", this.isRequestForDefaultClient(request) ? this.azureClient.getAccessTokenScopes() : request.getClientRegistration().getScopes());
        body.add((Object)"scope", (Object)scopes);
        return new RequestEntity((Object)body, (MultiValueMap)httpHeaders, requestEntity.getMethod(), requestEntity.getUrl());
    }

    private boolean isRequestForDefaultClient(OAuth2AuthorizationCodeGrantRequest request) {
        return request.getClientRegistration().equals(this.azureClient.getClient());
    }

    static HttpHeaders getHttpHeaders() {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.put("x-client-SKU", Collections.singletonList("az-sp-aad"));
        httpHeaders.put("x-client-VER", Collections.singletonList(ApplicationId.VERSION));
        httpHeaders.put("client-request-id", Collections.singletonList(UUID.randomUUID().toString()));
        return httpHeaders;
    }
}

