/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.autoconfigure.aad;

import com.azure.spring.aad.webapp.AuthorizationClientProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(value="azure.activedirectory")
public class AADAuthenticationProperties
implements InitializingBean {
    private static final long DEFAULT_JWK_SET_CACHE_LIFESPAN;
    private static final long DEFAULT_JWK_SET_CACHE_REFRESH_TIME;
    private UserGroupProperties userGroup = new UserGroupProperties();
    private String clientId;
    private String clientSecret;
    private String redirectUriTemplate;
    private String appIdUri;
    private int jwtConnectTimeout = 500;
    private int jwtReadTimeout = 500;
    private int jwtSizeLimit = 51200;
    private long jwkSetCacheLifespan = DEFAULT_JWK_SET_CACHE_LIFESPAN;
    private long jwkSetCacheRefreshTime = DEFAULT_JWK_SET_CACHE_REFRESH_TIME;
    private String tenantId = "common";
    private String postLogoutRedirectUri;
    private boolean allowTelemetry = true;
    private Boolean sessionStateless = false;
    private String baseUri;
    private String graphBaseUri;
    private String graphMembershipUri;
    private Map<String, AuthorizationClientProperties> authorizationClients = new HashMap<String, AuthorizationClientProperties>();

    @DeprecatedConfigurationProperty(reason="Configuration moved to UserGroup class to keep UserGroup properties together", replacement="azure.activedirectory.user-group.allowed-groups")
    public List<String> getActiveDirectoryGroups() {
        return this.userGroup.getAllowedGroups();
    }

    public boolean allowedGroupsConfigured() {
        return Optional.of(this).map(AADAuthenticationProperties::getUserGroup).map(UserGroupProperties::getAllowedGroups).map(allowedGroups -> !allowedGroups.isEmpty()).orElse(false);
    }

    public boolean isResourceServer() {
        return ClassUtils.isPresent((String)"org.springframework.security.oauth2.server.resource.BearerTokenAuthenticationToken", (ClassLoader)this.getClass().getClassLoader());
    }

    public boolean isWebApplication() {
        return ClassUtils.isPresent((String)"org.springframework.security.oauth2.client.registration.ClientRegistrationRepository", (ClassLoader)this.getClass().getClassLoader());
    }

    public UserGroupProperties getUserGroup() {
        return this.userGroup;
    }

    public void setUserGroup(UserGroupProperties userGroup) {
        this.userGroup = userGroup;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getRedirectUriTemplate() {
        return this.redirectUriTemplate;
    }

    public void setRedirectUriTemplate(String redirectUriTemplate) {
        this.redirectUriTemplate = redirectUriTemplate;
    }

    @Deprecated
    public void setActiveDirectoryGroups(List<String> activeDirectoryGroups) {
        this.userGroup.setAllowedGroups(activeDirectoryGroups);
    }

    public String getAppIdUri() {
        return this.appIdUri;
    }

    public void setAppIdUri(String appIdUri) {
        this.appIdUri = appIdUri;
    }

    public int getJwtConnectTimeout() {
        return this.jwtConnectTimeout;
    }

    public void setJwtConnectTimeout(int jwtConnectTimeout) {
        this.jwtConnectTimeout = jwtConnectTimeout;
    }

    public int getJwtReadTimeout() {
        return this.jwtReadTimeout;
    }

    public void setJwtReadTimeout(int jwtReadTimeout) {
        this.jwtReadTimeout = jwtReadTimeout;
    }

    public int getJwtSizeLimit() {
        return this.jwtSizeLimit;
    }

    public void setJwtSizeLimit(int jwtSizeLimit) {
        this.jwtSizeLimit = jwtSizeLimit;
    }

    public long getJwkSetCacheLifespan() {
        return this.jwkSetCacheLifespan;
    }

    public void setJwkSetCacheLifespan(long jwkSetCacheLifespan) {
        this.jwkSetCacheLifespan = jwkSetCacheLifespan;
    }

    public long getJwkSetCacheRefreshTime() {
        return this.jwkSetCacheRefreshTime;
    }

    public void setJwkSetCacheRefreshTime(long jwkSetCacheRefreshTime) {
        this.jwkSetCacheRefreshTime = jwkSetCacheRefreshTime;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getPostLogoutRedirectUri() {
        return this.postLogoutRedirectUri;
    }

    public void setPostLogoutRedirectUri(String postLogoutRedirectUri) {
        this.postLogoutRedirectUri = postLogoutRedirectUri;
    }

    public boolean isAllowTelemetry() {
        return this.allowTelemetry;
    }

    public void setAllowTelemetry(boolean allowTelemetry) {
        this.allowTelemetry = allowTelemetry;
    }

    public Boolean getSessionStateless() {
        return this.sessionStateless;
    }

    public void setSessionStateless(Boolean sessionStateless) {
        this.sessionStateless = sessionStateless;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    public String getGraphBaseUri() {
        return this.graphBaseUri;
    }

    public void setGraphBaseUri(String graphBaseUri) {
        this.graphBaseUri = graphBaseUri;
    }

    public String getGraphMembershipUri() {
        return this.graphMembershipUri;
    }

    public void setGraphMembershipUri(String graphMembershipUri) {
        this.graphMembershipUri = graphMembershipUri;
    }

    public Map<String, AuthorizationClientProperties> getAuthorizationClients() {
        return this.authorizationClients;
    }

    public void setAuthorizationClients(Map<String, AuthorizationClientProperties> authorizationClients) {
        this.authorizationClients = authorizationClients;
    }

    public boolean isAllowedGroup(String group) {
        return Optional.ofNullable(this.getUserGroup()).map(UserGroupProperties::getAllowedGroups).orElseGet(Collections::emptyList).contains(group);
    }

    public void afterPropertiesSet() throws Exception {
        this.baseUri = !StringUtils.hasText((String)this.baseUri) ? "https://login.microsoftonline.com/" : this.addSlash(this.baseUri);
        this.graphBaseUri = !StringUtils.hasText((String)this.graphBaseUri) ? "https://graph.microsoft.com/" : this.addSlash(this.graphBaseUri);
        if (!StringUtils.hasText((String)this.graphMembershipUri)) {
            this.graphMembershipUri = this.graphBaseUri + "v1.0/me/memberOf";
        }
        if (!this.graphMembershipUri.startsWith(this.graphBaseUri)) {
            throw new IllegalStateException("azure.activedirectory.graph-base-uri should be the prefix of azure.activedirectory.graph-membership-uri. azure.activedirectory.graph-base-uri = " + this.graphBaseUri + ", azure.activedirectory.graph-membership-uri = " + this.graphMembershipUri + ".");
        }
    }

    private String addSlash(String uri) {
        return uri.endsWith("/") ? uri : uri + "/";
    }

    static {
        DEFAULT_JWK_SET_CACHE_REFRESH_TIME = DEFAULT_JWK_SET_CACHE_LIFESPAN = TimeUnit.MINUTES.toMillis(5L);
    }

    public static class UserGroupProperties {
        private List<String> allowedGroups = new ArrayList<String>();

        public List<String> getAllowedGroups() {
            return this.allowedGroups;
        }

        public void setAllowedGroups(List<String> allowedGroups) {
            this.allowedGroups = allowedGroups;
        }
    }
}

