/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.autoconfigure.cosmos;

import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.models.CosmosDatabaseResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.util.Assert;

public class CosmosHealthIndicator
extends AbstractHealthIndicator {
    private static final Logger LOGGER = LoggerFactory.getLogger(CosmosHealthIndicator.class);
    @Value(value="${azure.cosmos.database}")
    private String dbName;
    @Value(value="${azure.cosmos.uri}")
    private String uri;
    private final CosmosAsyncClient cosmosAsyncClient;

    public CosmosHealthIndicator(CosmosAsyncClient cosmosAsyncClient) {
        super("Cosmos health check failed");
        Assert.notNull((Object)cosmosAsyncClient, (String)"CosmosClient must not be null");
        this.cosmosAsyncClient = cosmosAsyncClient;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        CosmosDatabaseResponse response = (CosmosDatabaseResponse)this.cosmosAsyncClient.getDatabase(this.dbName).read().block();
        if (response != null) {
            LOGGER.info("The health indicator cost {} RUs, cosmos uri: {}, dbName: {}", new Object[]{response.getRequestCharge(), this.uri, this.dbName});
        }
        if (response == null) {
            builder.down();
        } else {
            builder.up().withDetail("database", (Object)response.getProperties().getId());
        }
    }
}

