/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.autoconfigure.storage.actuator;

import com.azure.spring.autoconfigure.storage.actuator.Constants;
import com.azure.storage.blob.BlobServiceAsyncClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.models.StorageAccountInfo;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;

public class BlobStorageHealthIndicator
implements HealthIndicator {
    private final BlobServiceAsyncClient internalClient;

    public BlobStorageHealthIndicator(BlobServiceClientBuilder blobServiceClientBuilder) {
        this.internalClient = blobServiceClientBuilder == null ? null : blobServiceClientBuilder.buildAsyncClient();
    }

    public Health health() {
        Health.Builder healthBuilder;
        block6: {
            healthBuilder = new Health.Builder();
            try {
                if (this.internalClient == null) {
                    healthBuilder.status(Constants.NOT_CONFIGURED_STATUS);
                    break block6;
                }
                healthBuilder.withDetail("URL", (Object)this.internalClient.getAccountUrl());
                try {
                    StorageAccountInfo info = (StorageAccountInfo)this.internalClient.getAccountInfo().block(Constants.POLL_TIMEOUT);
                    if (info != null) {
                        healthBuilder.up();
                    }
                }
                catch (Exception e) {
                    healthBuilder.down((Throwable)e);
                }
            }
            catch (Exception e) {
                healthBuilder.status("Could not complete health check.").down((Throwable)e);
            }
        }
        return healthBuilder.build();
    }
}

