/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.autoconfigure.cosmos;

import com.azure.cosmos.ConnectionMode;
import com.azure.cosmos.ConsistencyLevel;
import com.azure.spring.data.cosmos.core.ResponseDiagnosticsProcessor;
import java.util.regex.Pattern;
import javax.validation.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(value="azure.cosmos")
public class CosmosProperties
implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(CosmosProperties.class);
    public static final String URI_REGEX = "http[s]{0,1}://.*.documents.azure.com.*";
    public static final String LOCAL_URI_REGEX = "^(http[s]{0,1}://)*localhost.*|^127(?:\\.[0-9]+){0,2}\\.[0-9]+.*";
    @NotEmpty
    private String uri;
    private boolean validateUri = true;
    @NotEmpty
    private String key;
    private ConsistencyLevel consistencyLevel;
    @NotEmpty
    private String database;
    private boolean populateQueryMetrics;
    private boolean allowTelemetry = true;
    private ConnectionMode connectionMode;
    private ResponseDiagnosticsProcessor responseDiagnosticsProcessor = responseDiagnostics -> {
        if (this.populateQueryMetrics) {
            LOGGER.info("Response Diagnostics {}", (Object)responseDiagnostics);
        }
    };

    public void afterPropertiesSet() {
        this.validateUri();
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String databaseName) {
        this.database = databaseName;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public void setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(reason="Deprecate the telemetry endpoint and use HTTP header User Agent instead.")
    public boolean isAllowTelemetry() {
        return this.allowTelemetry;
    }

    public void setAllowTelemetry(boolean allowTelemetry) {
        this.allowTelemetry = allowTelemetry;
    }

    public boolean isValidateUri() {
        return this.validateUri;
    }

    public void setValidateUri(boolean validateUri) {
        this.validateUri = validateUri;
    }

    public boolean isPopulateQueryMetrics() {
        return this.populateQueryMetrics;
    }

    public void setPopulateQueryMetrics(boolean populateQueryMetrics) {
        this.populateQueryMetrics = populateQueryMetrics;
    }

    public ResponseDiagnosticsProcessor getResponseDiagnosticsProcessor() {
        return this.responseDiagnosticsProcessor;
    }

    public void setResponseDiagnosticsProcessor(ResponseDiagnosticsProcessor responseDiagnosticsProcessor) {
        this.responseDiagnosticsProcessor = responseDiagnosticsProcessor;
    }

    public ConnectionMode getConnectionMode() {
        return this.connectionMode;
    }

    public void setConnectionMode(ConnectionMode connectionMode) {
        this.connectionMode = connectionMode;
    }

    private void validateUri() {
        if (!this.isValidateUri()) {
            return;
        }
        if (Pattern.matches(LOCAL_URI_REGEX, this.uri)) {
            return;
        }
        if (!Pattern.matches(URI_REGEX, this.uri)) {
            throw new IllegalArgumentException("the uri's pattern specified in 'azure.cosmos.uri' is not supported, only sql/core api is supported, please check https://docs.microsoft.com/en-us/azure/cosmos-db/ for more info.");
        }
    }
}

