/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.utils;

import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class ApplicationId {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationId.class);
    public static final String VERSION = ApplicationId.getVersion();
    public static final String AZURE_SPRING_KEY_VAULT = "az-sp-kv/" + VERSION;
    public static final String AZURE_SPRING_SERVICE_BUS = "az-sp-bus/" + VERSION;
    public static final String AZURE_SPRING_STORAGE_BLOB = "az-sp-sb/" + VERSION;
    public static final String AZURE_SPRING_STORAGE_FILES = "az-sp-sf/" + VERSION;
    public static final String AZURE_SPRING_AAD = "az-sp-aad";
    public static final String AZURE_SPRING_B2C = "az-sp-b2c";

    private static String getVersion() {
        String version = "unknown";
        try {
            Properties properties = PropertiesLoaderUtils.loadProperties((Resource)new ClassPathResource("project.properties"));
            version = properties.getProperty("version");
        }
        catch (IOException e) {
            LOGGER.warn("Can not get version.");
        }
        return version;
    }
}

