/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.aad.webapp;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.reactive.function.client.WebClientResponseException;

public class AADHandleConditionalAccessFilter
extends OncePerRequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AADHandleConditionalAccessFilter.class);

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception exception) {
            Map authParameters = Optional.of(exception).map(Throwable::getCause).filter(e -> e instanceof WebClientResponseException).map(e -> (WebClientResponseException)e).map(WebClientResponseException::getHeaders).map(httpHeaders -> httpHeaders.get((Object)"WWW-Authenticate")).map(list -> (String)list.get(0)).map(this::parseAuthParameters).orElse(null);
            if (authParameters != null && authParameters.containsKey("CONDITIONAL_ACCESS_POLICY_CLAIMS")) {
                request.getSession().setAttribute("CONDITIONAL_ACCESS_POLICY_CLAIMS", authParameters.get("CONDITIONAL_ACCESS_POLICY_CLAIMS"));
                response.setStatus(302);
                try {
                    response.sendRedirect("/oauth2/authorization/azure");
                }
                catch (IOException e2) {
                    LOGGER.error("Failed to redirect at this response.", (Throwable)exception);
                }
                return;
            }
            throw exception;
        }
    }

    private Map<String, String> parseAuthParameters(String wwwAuthenticateHeader) {
        return Stream.of(wwwAuthenticateHeader).filter(header -> !StringUtils.isEmpty((Object)header)).filter(header -> header.startsWith("Bearer ")).map(str -> str.substring("Bearer ".length() + 1, str.length() - 1)).map(str -> str.split(", ")).flatMap(Stream::of).map(parameter -> parameter.split("=")).filter(parameter -> ((String[])parameter).length > 1).collect(Collectors.toMap(parameters -> parameters[0], parameters -> parameters[1]));
    }
}

