/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.aad.webapp;

import com.azure.spring.aad.AADClientRegistrationRepository;
import com.azure.spring.aad.webapp.AADWebAppClientRegistrationRepository;
import com.azure.spring.aad.webapp.JacksonHttpSessionOAuth2AuthorizedClientRepository;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.function.Consumer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2AuthorizationContext;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.RefreshTokenOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class AADOAuth2AuthorizedClientRepository
implements OAuth2AuthorizedClientRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(AADOAuth2AuthorizedClientRepository.class);
    private final AADWebAppClientRegistrationRepository repo;
    private final OAuth2AuthorizedClientRepository delegate;
    private final OAuth2AuthorizedClientProvider provider;

    public AADOAuth2AuthorizedClientRepository(AADWebAppClientRegistrationRepository repo) {
        this(repo, new JacksonHttpSessionOAuth2AuthorizedClientRepository(), (OAuth2AuthorizedClientProvider)new RefreshTokenOAuth2AuthorizedClientProvider());
    }

    public AADOAuth2AuthorizedClientRepository(AADWebAppClientRegistrationRepository repo, OAuth2AuthorizedClientRepository delegate, OAuth2AuthorizedClientProvider provider) {
        this.repo = repo;
        this.delegate = delegate;
        this.provider = provider;
    }

    public void saveAuthorizedClient(OAuth2AuthorizedClient client, Authentication principal, HttpServletRequest request, HttpServletResponse response) {
        this.delegate.saveAuthorizedClient(client, principal, request, response);
    }

    public <T extends OAuth2AuthorizedClient> T loadAuthorizedClient(String id, Authentication principal, HttpServletRequest request) {
        OAuth2AuthorizedClient result = this.delegate.loadAuthorizedClient(id, principal, request);
        if (result != null) {
            return (T)result;
        }
        if (this.repo.isClientNeedConsentWhenLogin(id)) {
            T azureClient = this.loadAuthorizedClient(this.getAzureClientId(), principal, request);
            OAuth2AuthorizedClient fakeAuthzClient = this.createFakeAuthzClient((OAuth2AuthorizedClient)azureClient, id, principal);
            OAuth2AuthorizationContext.Builder contextBuilder = OAuth2AuthorizationContext.withAuthorizedClient((OAuth2AuthorizedClient)fakeAuthzClient);
            String[] scopes = null;
            if (!AADClientRegistrationRepository.isDefaultClient(id)) {
                scopes = this.repo.findByRegistrationId(id).getScopes().toArray(new String[0]);
            }
            OAuth2AuthorizationContext context = contextBuilder.principal(principal).attributes(this.getAttributesConsumer(scopes)).build();
            OAuth2AuthorizedClient clientGotByRefreshToken = this.provider.authorize(context);
            try {
                ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
                this.delegate.saveAuthorizedClient(clientGotByRefreshToken, principal, request, attributes.getResponse());
            }
            catch (IllegalStateException exception) {
                LOGGER.warn("Can not save OAuth2AuthorizedClient.", (Throwable)exception);
            }
            return (T)clientGotByRefreshToken;
        }
        return null;
    }

    private Consumer<Map<String, Object>> getAttributesConsumer(String[] scopes) {
        return attributes -> attributes.put(OAuth2AuthorizationContext.REQUEST_SCOPE_ATTRIBUTE_NAME, scopes);
    }

    private String getAzureClientId() {
        return this.repo.getAzureClient().getClient().getRegistrationId();
    }

    private OAuth2AuthorizedClient createFakeAuthzClient(OAuth2AuthorizedClient azureClient, String id, Authentication principal) {
        if (azureClient == null || azureClient.getRefreshToken() == null) {
            return null;
        }
        OAuth2AccessToken accessToken = new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, "non-access-token", Instant.MIN, Instant.now().minus(100L, ChronoUnit.DAYS));
        return new OAuth2AuthorizedClient(this.repo.findByRegistrationId(id), principal.getName(), accessToken, azureClient.getRefreshToken());
    }

    public void removeAuthorizedClient(String id, Authentication principal, HttpServletRequest request, HttpServletResponse response) {
        this.delegate.removeAuthorizedClient(id, principal, request, response);
    }
}

