/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.autoconfigure.b2c;

import com.azure.spring.autoconfigure.b2c.AADB2CConfigurationException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.constraints.NotBlank;
import org.hibernate.validator.constraints.URL;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(prefix="azure.activedirectory.b2c")
public class AADB2CProperties
implements InitializingBean {
    public static final String DEFAULT_LOGOUT_SUCCESS_URL = "http://localhost:8080/login";
    public static final String PREFIX = "azure.activedirectory.b2c";
    private static final String TENANT_NAME_PART_REGEX = "([A-Za-z0-9]+\\.)";
    protected static final String DEFAULT_KEY_SIGN_UP_OR_SIGN_IN = "sign-up-or-sign-in";
    protected static final String DEFAULT_KEY_PASSWORD_RESET = "password-reset";
    @Deprecated
    private String tenant;
    private String tenantId;
    private String appIdUri;
    private int jwtConnectTimeout = 500;
    private int jwtReadTimeout = 500;
    private int jwtSizeLimit = 51200;
    @NotBlank(message="client ID should not be blank")
    private @NotBlank(message="client ID should not be blank") String clientId;
    @NotBlank(message="client secret should not be blank")
    private @NotBlank(message="client secret should not be blank") String clientSecret;
    @URL(message="logout success should be valid URL")
    private @URL(message="logout success should be valid URL") String logoutSuccessUrl = "http://localhost:8080/login";
    private Map<String, Object> authenticateAdditionalParameters;
    private String userNameAttributeName;
    private boolean allowTelemetry = true;
    private String replyUrl = "{baseUrl}/login/oauth2/code/";
    @URL(message="baseUri should be valid URL")
    private @URL(message="baseUri should be valid URL") String baseUri;
    private String loginFlow = "sign-up-or-sign-in";
    private Map<String, String> userFlows = new HashMap<String, String>();

    public void afterPropertiesSet() {
        if (StringUtils.isEmpty((Object)this.tenant) && StringUtils.isEmpty((Object)this.baseUri)) {
            throw new AADB2CConfigurationException("'tenant' and 'baseUri' at least configure one item.");
        }
        if (!this.userFlows.keySet().contains(this.loginFlow)) {
            throw new AADB2CConfigurationException("Sign in user flow key '" + this.loginFlow + "' is not in 'user-flows' map.");
        }
    }

    protected String getPasswordReset() {
        Optional<String> keyOptional = this.userFlows.keySet().stream().filter(key -> key.equalsIgnoreCase(DEFAULT_KEY_PASSWORD_RESET)).findAny();
        return keyOptional.isPresent() ? this.userFlows.get(keyOptional.get()) : null;
    }

    public String getBaseUri() {
        if (StringUtils.hasText((String)this.tenant) && StringUtils.isEmpty((Object)this.baseUri)) {
            return String.format("https://%s.b2clogin.com/%s.onmicrosoft.com/", this.tenant, this.tenant);
        }
        return this.baseUri;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    @DeprecatedConfigurationProperty(reason="Configuration updated to baseUri", replacement="azure.activedirectory.b2c.base-uri")
    public String getTenant() {
        if (StringUtils.hasText((String)this.baseUri)) {
            Matcher matcher = Pattern.compile(TENANT_NAME_PART_REGEX).matcher(this.baseUri);
            if (matcher.find()) {
                String matched = matcher.group();
                return matched.substring(0, matched.length() - 1);
            }
            throw new AADB2CConfigurationException("Unable to resolve the 'tenant' name.");
        }
        return this.tenant;
    }

    public Map<String, String> getUserFlows() {
        return this.userFlows;
    }

    public void setUserFlows(Map<String, String> userFlows) {
        this.userFlows = userFlows;
    }

    public String getLoginFlow() {
        return this.loginFlow;
    }

    public void setLoginFlow(String loginFlow) {
        this.loginFlow = loginFlow;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getLogoutSuccessUrl() {
        return this.logoutSuccessUrl;
    }

    public void setLogoutSuccessUrl(String logoutSuccessUrl) {
        this.logoutSuccessUrl = logoutSuccessUrl;
    }

    public Map<String, Object> getAuthenticateAdditionalParameters() {
        return this.authenticateAdditionalParameters;
    }

    public void setAuthenticateAdditionalParameters(Map<String, Object> authenticateAdditionalParameters) {
        this.authenticateAdditionalParameters = authenticateAdditionalParameters;
    }

    public boolean isAllowTelemetry() {
        return this.allowTelemetry;
    }

    public void setAllowTelemetry(boolean allowTelemetry) {
        this.allowTelemetry = allowTelemetry;
    }

    public String getUserNameAttributeName() {
        return this.userNameAttributeName;
    }

    public void setUserNameAttributeName(String userNameAttributeName) {
        this.userNameAttributeName = userNameAttributeName;
    }

    public String getReplyUrl() {
        return this.replyUrl;
    }

    public void setReplyUrl(String replyUrl) {
        this.replyUrl = replyUrl;
    }

    public String getAppIdUri() {
        return this.appIdUri;
    }

    public void setAppIdUri(String appIdUri) {
        this.appIdUri = appIdUri;
    }

    public int getJwtConnectTimeout() {
        return this.jwtConnectTimeout;
    }

    public void setJwtConnectTimeout(int jwtConnectTimeout) {
        this.jwtConnectTimeout = jwtConnectTimeout;
    }

    public int getJwtReadTimeout() {
        return this.jwtReadTimeout;
    }

    public void setJwtReadTimeout(int jwtReadTimeout) {
        this.jwtReadTimeout = jwtReadTimeout;
    }

    public int getJwtSizeLimit() {
        return this.jwtSizeLimit;
    }

    public void setJwtSizeLimit(int jwtSizeLimit) {
        this.jwtSizeLimit = jwtSizeLimit;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }
}

