/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.aad.webapp;

import com.azure.spring.aad.webapp.AzureClientRegistration;
import com.azure.spring.common.AbstractOAuth2AuthorizationCodeGrantRequestEntityConverter;
import org.springframework.http.RequestEntity;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequest;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class AADOAuth2AuthorizationCodeGrantRequestEntityConverter
extends AbstractOAuth2AuthorizationCodeGrantRequestEntityConverter {
    private final AzureClientRegistration azureClient;

    public AADOAuth2AuthorizationCodeGrantRequestEntityConverter(AzureClientRegistration client) {
        this.azureModule = "az-sp-aad";
        this.azureClient = client;
    }

    @Override
    public RequestEntity<?> convert(OAuth2AuthorizationCodeGrantRequest request) {
        return super.convert(request);
    }

    private boolean isRequestForDefaultClient(OAuth2AuthorizationCodeGrantRequest request) {
        return request.getClientRegistration().equals(this.azureClient.getClient());
    }

    @Override
    public MultiValueMap<String, String> getHttpBody(OAuth2AuthorizationCodeGrantRequest request) {
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        String scopes = String.join((CharSequence)" ", this.isRequestForDefaultClient(request) ? this.azureClient.getAccessTokenScopes() : request.getClientRegistration().getScopes());
        body.add((Object)"scope", (Object)scopes);
        return body;
    }
}

