/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.aad.webapp;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.security.core.Authentication;
import org.springframework.security.jackson2.CoreJackson2Module;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.jackson2.OAuth2ClientJackson2Module;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.util.Assert;

public class JacksonHttpSessionOAuth2AuthorizedClientRepository
implements OAuth2AuthorizedClientRepository {
    private static final String AUTHORIZED_CLIENTS_ATTR_NAME = JacksonHttpSessionOAuth2AuthorizedClientRepository.class.getName() + ".AUTHORIZED_CLIENTS";
    private final ObjectMapper objectMapper = new ObjectMapper();
    private static final TypeReference<Map<String, OAuth2AuthorizedClient>> TYPE_REFERENCE = new TypeReference<Map<String, OAuth2AuthorizedClient>>(){};

    public JacksonHttpSessionOAuth2AuthorizedClientRepository() {
        this.objectMapper.registerModule((Module)new OAuth2ClientJackson2Module());
        this.objectMapper.registerModule((Module)new CoreJackson2Module());
        this.objectMapper.registerModule((Module)new JavaTimeModule());
    }

    public <T extends OAuth2AuthorizedClient> T loadAuthorizedClient(String clientRegistrationId, Authentication principal, HttpServletRequest request) {
        Assert.hasText((String)clientRegistrationId, (String)"clientRegistrationId cannot be empty");
        Assert.notNull((Object)request, (String)"request cannot be null");
        return (T)this.getAuthorizedClients(request).get(clientRegistrationId);
    }

    public void saveAuthorizedClient(OAuth2AuthorizedClient authorizedClient, Authentication principal, HttpServletRequest request, HttpServletResponse response) {
        Assert.notNull((Object)authorizedClient, (String)"authorizedClient cannot be null");
        Assert.notNull((Object)request, (String)"request cannot be null");
        Assert.notNull((Object)response, (String)"response cannot be null");
        Map<String, OAuth2AuthorizedClient> authorizedClients = this.getAuthorizedClients(request);
        authorizedClients.put(authorizedClient.getClientRegistration().getRegistrationId(), authorizedClient);
        request.getSession().setAttribute(AUTHORIZED_CLIENTS_ATTR_NAME, (Object)this.toString(authorizedClients));
    }

    public void removeAuthorizedClient(String clientRegistrationId, Authentication principal, HttpServletRequest request, HttpServletResponse response) {
        Assert.hasText((String)clientRegistrationId, (String)"clientRegistrationId cannot be empty");
        Assert.notNull((Object)request, (String)"request cannot be null");
        Map<String, OAuth2AuthorizedClient> authorizedClients = this.getAuthorizedClients(request);
        if (!authorizedClients.isEmpty() && authorizedClients.remove(clientRegistrationId) != null) {
            if (!authorizedClients.isEmpty()) {
                request.getSession().setAttribute(AUTHORIZED_CLIENTS_ATTR_NAME, (Object)this.toString(authorizedClients));
            } else {
                request.getSession().removeAttribute(AUTHORIZED_CLIENTS_ATTR_NAME);
            }
        }
    }

    private String toString(Map<String, OAuth2AuthorizedClient> authorizedClients) {
        String result;
        try {
            result = this.objectMapper.writeValueAsString(authorizedClients);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    private Map<String, OAuth2AuthorizedClient> getAuthorizedClients(HttpServletRequest request) {
        Map authorizedClients;
        HttpSession session = request.getSession(false);
        String authorizedClientsString = Optional.ofNullable(session).map(s -> s.getAttribute(AUTHORIZED_CLIENTS_ATTR_NAME)).orElse(null);
        if (authorizedClientsString == null) {
            return new HashMap<String, OAuth2AuthorizedClient>();
        }
        try {
            authorizedClients = (Map)this.objectMapper.readValue(authorizedClientsString, TYPE_REFERENCE);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
        return authorizedClients;
    }
}

