/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.autoconfigure.b2c;

import com.azure.spring.autoconfigure.b2c.AADB2CAuthorizationRequestResolver;
import com.azure.spring.autoconfigure.b2c.AADB2CConditions;
import com.azure.spring.autoconfigure.b2c.AADB2CLogoutSuccessHandler;
import com.azure.spring.autoconfigure.b2c.AADB2COAuth2ClientConfiguration;
import com.azure.spring.autoconfigure.b2c.AADB2COidcLoginConfigurer;
import com.azure.spring.autoconfigure.b2c.AADB2CProperties;
import com.azure.spring.telemetry.TelemetryData;
import com.azure.spring.telemetry.TelemetrySender;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.lang.NonNull;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.util.ClassUtils;

@Configuration
@ConditionalOnResource(resources={"classpath:aadb2c.enable.config"})
@Conditional(value={AADB2CConditions.CommonCondition.class, AADB2CConditions.UserFlowCondition.class})
@EnableConfigurationProperties(value={AADB2CProperties.class})
@Import(value={AADB2COAuth2ClientConfiguration.class})
public class AADB2CAutoConfiguration {
    private final ClientRegistrationRepository repository;
    private final AADB2CProperties properties;

    public AADB2CAutoConfiguration(@NonNull ClientRegistrationRepository repository, @NonNull AADB2CProperties properties) {
        this.repository = repository;
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public AADB2CAuthorizationRequestResolver b2cOAuth2AuthorizationRequestResolver() {
        return new AADB2CAuthorizationRequestResolver(this.repository, this.properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public AADB2CLogoutSuccessHandler b2cLogoutSuccessHandler() {
        return new AADB2CLogoutSuccessHandler(this.properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public AADB2COidcLoginConfigurer b2cLoginConfigurer(AADB2CLogoutSuccessHandler handler, AADB2CAuthorizationRequestResolver resolver) {
        return new AADB2COidcLoginConfigurer(handler, resolver);
    }

    @PostConstruct
    private void sendTelemetry() {
        if (this.properties.isAllowTelemetry()) {
            HashMap<String, String> events = new HashMap<String, String>();
            TelemetrySender sender = new TelemetrySender();
            events.put("serviceName", TelemetryData.getClassPackageSimpleName(AADB2CAutoConfiguration.class));
            events.put("tenantName", this.properties.getTenant());
            sender.send(ClassUtils.getUserClass(this.getClass()).getSimpleName(), events);
        }
    }
}

