/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.autoconfigure.cosmos;

import com.azure.cosmos.CosmosAsyncClient;
import com.azure.spring.autoconfigure.cosmos.CosmosAutoConfiguration;
import com.azure.spring.autoconfigure.cosmos.CosmosHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@ConditionalOnClass(value={CosmosAsyncClient.class, HealthIndicator.class})
@PropertySource(value={"classpath:/azure-spring-actuator.properties"})
@AutoConfigureAfter(value={CosmosAutoConfiguration.class})
public class CosmosHealthConfiguration {
    @Bean
    @ConditionalOnEnabledHealthIndicator(value="azure-cosmos")
    public HealthIndicator cosmosHealthContributor(CosmosAsyncClient cosmosAsyncClient) {
        return new CosmosHealthIndicator(cosmosAsyncClient);
    }
}

