/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.aad;

import org.springframework.security.oauth2.core.AuthorizationGrantType;

public enum AADAuthorizationGrantType {
    CLIENT_CREDENTIALS("client_credentials"),
    AUTHORIZATION_CODE("authorization_code"),
    ON_BEHALF_OF("on_behalf_of");

    private final String authorizationGrantType;

    private AADAuthorizationGrantType(String authorizationGrantType) {
        this.authorizationGrantType = "on-behalf-of".equals(authorizationGrantType) ? "on_behalf_of" : authorizationGrantType;
    }

    public String getValue() {
        return this.authorizationGrantType;
    }

    public boolean isSameGrantType(AuthorizationGrantType grantType) {
        return this.authorizationGrantType.equals(grantType.getValue());
    }
}

