/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.aad.webapi;

import com.azure.spring.aad.AADJwtGrantedAuthoritiesConverter;
import com.azure.spring.aad.AADOAuth2AuthenticatedPrincipal;
import com.azure.spring.aad.AbstractJwtBearerTokenAuthenticationConverter;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;

public class AADJwtBearerTokenAuthenticationConverter
extends AbstractJwtBearerTokenAuthenticationConverter {
    public AADJwtBearerTokenAuthenticationConverter() {
        this("sub", AADJwtGrantedAuthoritiesConverter.DEFAULT_CLAIM_TO_AUTHORITY_PREFIX_MAP);
    }

    public AADJwtBearerTokenAuthenticationConverter(String authoritiesClaimName) {
        this(authoritiesClaimName, "SCOPE_");
    }

    public AADJwtBearerTokenAuthenticationConverter(String authoritiesClaimName, String authorityPrefix) {
        this(null, AADJwtBearerTokenAuthenticationConverter.buildClaimToAuthorityPrefixMap(authoritiesClaimName, authorityPrefix));
    }

    public AADJwtBearerTokenAuthenticationConverter(String principalClaimName, Map<String, String> claimToAuthorityPrefixMap) {
        super(principalClaimName, claimToAuthorityPrefixMap);
    }

    @Override
    protected OAuth2AuthenticatedPrincipal getAuthenticatedPrincipal(Map<String, Object> headers, Map<String, Object> claims, Collection<GrantedAuthority> authorities, String tokenValue) {
        String name = Optional.ofNullable(this.principalClaimName).map(n -> (String)claims.get(n)).orElseGet(() -> (String)claims.get("sub"));
        return new AADOAuth2AuthenticatedPrincipal(headers, claims, authorities, tokenValue, name);
    }
}

