/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.aad.webapp;

import com.azure.spring.aad.AADClientRegistrationRepository;
import com.azure.spring.aad.webapp.AADHandleConditionalAccessFilter;
import com.azure.spring.aad.webapp.AADOAuth2AuthorizationCodeGrantRequestEntityConverter;
import com.azure.spring.aad.webapp.AADOAuth2AuthorizationRequestResolver;
import com.azure.spring.autoconfigure.aad.AADAuthenticationProperties;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.oauth2.client.endpoint.DefaultAuthorizationCodeTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.web.logout.OidcClientInitiatedLogoutSuccessHandler;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestRedirectFilter;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.util.StringUtils;

public abstract class AADWebSecurityConfigurerAdapter
extends WebSecurityConfigurerAdapter {
    @Autowired
    private AADClientRegistrationRepository repo;
    @Autowired
    private OAuth2UserService<OidcUserRequest, OidcUser> oidcUserService;
    @Autowired
    protected AADAuthenticationProperties properties;

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)http.oauth2Login().authorizationEndpoint().authorizationRequestResolver(this.requestResolver()).and().tokenEndpoint().accessTokenResponseClient(this.accessTokenResponseClient()).and().userInfoEndpoint().oidcUserService(this.oidcUserService).and().and()).logout().logoutSuccessHandler(this.oidcLogoutSuccessHandler()).and()).addFilterAfter((Filter)new AADHandleConditionalAccessFilter(), OAuth2AuthorizationRequestRedirectFilter.class);
    }

    protected LogoutSuccessHandler oidcLogoutSuccessHandler() {
        OidcClientInitiatedLogoutSuccessHandler oidcLogoutSuccessHandler = new OidcClientInitiatedLogoutSuccessHandler((ClientRegistrationRepository)this.repo);
        String uri = this.properties.getPostLogoutRedirectUri();
        if (StringUtils.hasText((String)uri)) {
            oidcLogoutSuccessHandler.setPostLogoutRedirectUri(uri);
        }
        return oidcLogoutSuccessHandler;
    }

    protected OAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> accessTokenResponseClient() {
        DefaultAuthorizationCodeTokenResponseClient result = new DefaultAuthorizationCodeTokenResponseClient();
        result.setRequestEntityConverter((Converter)new AADOAuth2AuthorizationCodeGrantRequestEntityConverter(this.repo.getAzureClient()));
        return result;
    }

    protected OAuth2AuthorizationRequestResolver requestResolver() {
        return new AADOAuth2AuthorizationRequestResolver(this.repo, this.properties);
    }
}

