/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.config.web;

import com.azure.spring.cloud.config.properties.AppConfigurationStoreMonitoring;
import com.azure.spring.cloud.config.properties.ConfigStore;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class AppConfigurationEndpoint {
    private static final String CONFIG_STORE_TOPIC = "configurationstores";
    private final String endpoint;
    private final String store;
    private final List<ConfigStore> configStores;
    private final Map<String, String> allRequestParams;

    public AppConfigurationEndpoint(JsonNode request, List<ConfigStore> configStores, Map<String, String> allRequestParams) {
        this.configStores = configStores;
        this.allRequestParams = allRequestParams;
        JsonNode requestTopic = request.findValue("topic");
        if (requestTopic == null) {
            throw new IllegalArgumentException("Refresh request missing topic field.");
        }
        String topic = requestTopic.asText();
        this.store = topic.substring(topic.toLowerCase(Locale.ROOT).indexOf(CONFIG_STORE_TOPIC) + CONFIG_STORE_TOPIC.length() + 1);
        this.endpoint = String.format("https://%s.azconfig.io", this.store);
    }

    public boolean authenticate() {
        for (ConfigStore configStore : this.configStores) {
            if (!configStore.getEndpoint().equals(this.endpoint)) continue;
            AppConfigurationStoreMonitoring.PushNotification pushNotification = configStore.getMonitoring().getPushNotification();
            if (!pushNotification.getPrimaryToken().isValid() && !pushNotification.getSecondaryToken().isValid()) {
                return false;
            }
            if (this.isTokenMatch(pushNotification.getPrimaryToken())) {
                return true;
            }
            if (!this.isTokenMatch(pushNotification.getSecondaryToken())) continue;
            return true;
        }
        return false;
    }

    private boolean isTokenMatch(AppConfigurationStoreMonitoring.AccessToken token) {
        return token != null && this.allRequestParams.containsKey(token.getName()) && token.getSecret().equals(this.allRequestParams.get(token.getName()));
    }

    public boolean triggerRefresh() {
        for (ConfigStore configStore : this.configStores) {
            if (!configStore.getEndpoint().equals(this.endpoint) || !configStore.getMonitoring().isEnabled()) continue;
            return true;
        }
        return false;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getStore() {
        return this.store;
    }
}

