/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.config.web.pushbusrefresh;

import com.azure.spring.cloud.config.properties.AppConfigurationProperties;
import com.azure.spring.cloud.config.web.AppConfigurationEndpoint;
import com.azure.spring.cloud.config.web.pushbusrefresh.AppConfigurationBusRefreshEvent;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.web.annotation.ControllerEndpoint;
import org.springframework.cloud.bus.endpoint.AbstractBusEndpoint;
import org.springframework.cloud.bus.event.Destination;
import org.springframework.cloud.bus.event.PathDestinationFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerEndpoint(id="appconfiguration-refresh-bus")
public final class AppConfigurationBusRefreshEndpoint
extends AbstractBusEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppConfigurationBusRefreshEndpoint.class);
    private final ObjectMapper objectmapper = new ObjectMapper();
    private final AppConfigurationProperties appConfiguration;

    public AppConfigurationBusRefreshEndpoint(ApplicationEventPublisher context, String appId, Destination.Factory destinationFactory, AppConfigurationProperties appConfiguration) {
        super(context, appId, destinationFactory);
        this.appConfiguration = appConfiguration;
    }

    @PostMapping(value={"/"})
    @ResponseBody
    public String refresh(HttpServletRequest request, HttpServletResponse response, @RequestParam Map<String, String> allRequestParams) throws IOException {
        AppConfigurationEndpoint validation;
        String reference = request.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
        JsonNode kvReference = this.objectmapper.readTree(reference);
        try {
            validation = new AppConfigurationEndpoint(kvReference, this.appConfiguration.getStores(), allRequestParams);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error(e.getMessage());
            return HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase();
        }
        if (!validation.authenticate()) {
            return HttpStatus.UNAUTHORIZED.getReasonPhrase();
        }
        JsonNode validationResponse = kvReference.findValue("validationCode");
        if (validationResponse != null) {
            return "{ \"validationResponse\": \"" + validationResponse.asText() + "\"}";
        }
        if (validation.triggerRefresh()) {
            this.publish((ApplicationEvent)new AppConfigurationBusRefreshEvent(validation.getEndpoint(), this, this.getInstanceId(), new PathDestinationFactory().getDestination(null)));
            return HttpStatus.OK.getReasonPhrase();
        }
        LOGGER.debug("Non Refreshable notification");
        return HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase();
    }
}

