/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.config.web.pushbusrefresh;

import com.azure.spring.cloud.config.AppConfigurationRefresh;
import com.azure.spring.cloud.config.web.pushbusrefresh.AppConfigurationBusRefreshEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public final class AppConfigurationBusRefreshEventListener
implements ApplicationListener<AppConfigurationBusRefreshEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppConfigurationBusRefreshEventListener.class);
    private final AppConfigurationRefresh appConfigurationRefresh;

    public AppConfigurationBusRefreshEventListener(AppConfigurationRefresh appConfigurationRefresh) {
        this.appConfigurationRefresh = appConfigurationRefresh;
    }

    public void onApplicationEvent(AppConfigurationBusRefreshEvent event) {
        try {
            this.appConfigurationRefresh.expireRefreshInterval(event.getEndpoint());
        }
        catch (Exception e) {
            LOGGER.error("Refresh failed with unexpected exception.", (Throwable)e);
        }
    }
}

