/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.config.web.pushrefresh;

import com.azure.spring.cloud.config.properties.AppConfigurationProperties;
import com.azure.spring.cloud.config.web.AppConfigurationEndpoint;
import com.azure.spring.cloud.config.web.pushrefresh.AppConfigurationRefreshEvent;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.web.annotation.ControllerEndpoint;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerEndpoint(id="appconfiguration-refresh")
public final class AppConfigurationRefreshEndpoint
implements ApplicationEventPublisherAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppConfigurationRefreshEndpoint.class);
    private final ContextRefresher contextRefresher;
    private final ObjectMapper objectmapper = new ObjectMapper();
    private final AppConfigurationProperties appConfiguration;
    private ApplicationEventPublisher publisher;

    public AppConfigurationRefreshEndpoint(ContextRefresher contextRefresher, AppConfigurationProperties appConfiguration) {
        this.contextRefresher = contextRefresher;
        this.appConfiguration = appConfiguration;
    }

    @PostMapping(value={"/"})
    @ResponseBody
    public String refresh(HttpServletRequest request, HttpServletResponse response, @RequestParam Map<String, String> allRequestParams) throws IOException {
        String reference = request.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
        JsonNode kvReference = this.objectmapper.readTree(reference);
        AppConfigurationEndpoint validation = new AppConfigurationEndpoint(kvReference, this.appConfiguration.getStores(), allRequestParams);
        if (!validation.authenticate()) {
            return HttpStatus.UNAUTHORIZED.getReasonPhrase();
        }
        JsonNode validationResponse = kvReference.findValue("validationCode");
        if (validationResponse != null) {
            return String.format("%s%s\"}", "{ \"validationResponse\": \"", validationResponse.asText());
        }
        if (this.contextRefresher != null) {
            if (validation.triggerRefresh()) {
                this.publisher.publishEvent((ApplicationEvent)new AppConfigurationRefreshEvent(validation.getEndpoint()));
                return HttpStatus.OK.getReasonPhrase();
            }
            LOGGER.debug("Non Refreshable notification");
            return HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase();
        }
        LOGGER.error("ContextRefresher Not Found. Unable to Refresh.");
        return HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase();
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }
}

