/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.config.web;

import com.azure.spring.cloud.config.AppConfigurationRefresh;
import com.azure.spring.cloud.config.properties.AppConfigurationProperties;
import com.azure.spring.cloud.config.web.pullrefresh.AppConfigurationEventListener;
import com.azure.spring.cloud.config.web.pushbusrefresh.AppConfigurationBusRefreshEndpoint;
import com.azure.spring.cloud.config.web.pushbusrefresh.AppConfigurationBusRefreshEventListener;
import com.azure.spring.cloud.config.web.pushrefresh.AppConfigurationRefreshEndpoint;
import com.azure.spring.cloud.config.web.pushrefresh.AppConfigurationRefreshEventListener;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.bus.BusProperties;
import org.springframework.cloud.bus.event.Destination;
import org.springframework.cloud.bus.jackson.RemoteApplicationEventScan;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.cloud.endpoint.RefreshEndpoint;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={AppConfigurationProperties.class})
@RemoteApplicationEventScan
@ConditionalOnBean(value={AppConfigurationRefresh.class})
public class AppConfigurationWebAutoConfiguration {
    @Bean
    @ConditionalOnClass(value={RefreshEndpoint.class})
    public AppConfigurationEventListener configListener(AppConfigurationRefresh appConfigurationRefresh) {
        return new AppConfigurationEventListener(appConfigurationRefresh);
    }

    @Configuration
    @ConditionalOnClass(name={"org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties", "org.springframework.cloud.bus.BusProperties", "org.springframework.cloud.bus.event.RefreshRemoteApplicationEvent", "org.springframework.cloud.endpoint.RefreshEndpoint"})
    public static class AppConfigurationBusConfiguration {
        @Bean
        public AppConfigurationBusRefreshEndpoint appConfigurationBusRefreshEndpoint(ApplicationContext context, BusProperties bus, AppConfigurationProperties appConfiguration, Destination.Factory destinationFactory) {
            return new AppConfigurationBusRefreshEndpoint((ApplicationEventPublisher)context, bus.getId(), destinationFactory, appConfiguration);
        }

        @Bean
        public AppConfigurationBusRefreshEventListener appConfigurationBusRefreshEventListener(AppConfigurationRefresh appConfigurationRefresh) {
            return new AppConfigurationBusRefreshEventListener(appConfigurationRefresh);
        }
    }

    @Configuration
    @ConditionalOnClass(name={"org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties", "org.springframework.cloud.endpoint.RefreshEndpoint"})
    public static class AppConfigurationPushRefreshConfiguration {
        @Bean
        public AppConfigurationRefreshEndpoint appConfigurationRefreshEndpoint(ContextRefresher contextRefresher, AppConfigurationProperties appConfiguration) {
            return new AppConfigurationRefreshEndpoint(contextRefresher, appConfiguration);
        }

        @Bean
        public AppConfigurationRefreshEventListener appConfigurationRefreshEventListener(AppConfigurationRefresh appConfigurationRefresh) {
            return new AppConfigurationRefreshEventListener(appConfigurationRefresh);
        }
    }
}

