/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.config.web.pushrefresh;

import com.azure.spring.cloud.config.AppConfigurationRefresh;
import com.azure.spring.cloud.config.web.pushrefresh.AppConfigurationRefreshEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public final class AppConfigurationRefreshEventListener
implements ApplicationListener<AppConfigurationRefreshEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppConfigurationRefreshEventListener.class);
    private final AppConfigurationRefresh appConfigurationRefresh;

    public AppConfigurationRefreshEventListener(AppConfigurationRefresh appConfigurationRefresh) {
        this.appConfigurationRefresh = appConfigurationRefresh;
    }

    public void onApplicationEvent(AppConfigurationRefreshEvent event) {
        try {
            this.appConfigurationRefresh.expireRefreshInterval(event.getEndpoint(), event.getSyncToken());
        }
        catch (Exception e) {
            LOGGER.error("Refresh failed with unexpected exception.", (Throwable)e);
        }
    }
}

