/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.config;

import com.azure.data.appconfiguration.ConfigurationClient;
import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.data.appconfiguration.models.SettingSelector;
import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import com.azure.spring.cloud.config.JsonConfigurationParser;
import com.azure.spring.cloud.config.KeyVaultCredentialProvider;
import com.azure.spring.cloud.config.SecretClientBuilderSetup;
import com.azure.spring.cloud.config.feature.management.entity.Feature;
import com.azure.spring.cloud.config.feature.management.entity.FeatureFilterEvaluationContext;
import com.azure.spring.cloud.config.feature.management.entity.FeatureManagementItem;
import com.azure.spring.cloud.config.feature.management.entity.FeatureSet;
import com.azure.spring.cloud.config.properties.AppConfigurationProperties;
import com.azure.spring.cloud.config.properties.AppConfigurationProviderProperties;
import com.azure.spring.cloud.config.properties.ConfigStore;
import com.azure.spring.cloud.config.stores.ClientStore;
import com.azure.spring.cloud.config.stores.KeyVaultClient;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class AppConfigurationPropertySource
extends EnumerablePropertySource<ConfigurationClient> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppConfigurationPropertySource.class);
    private static final String USERS = "users";
    private static final String USERS_CAPS = "Users";
    private static final String AUDIENCE = "Audience";
    private static final String GROUPS = "groups";
    private static final String GROUPS_CAPS = "Groups";
    private static final String TARGETING_FILTER = "targetingFilter";
    private static final String DEFAULT_ROLLOUT_PERCENTAGE = "defaultRolloutPercentage";
    private static final String DEFAULT_ROLLOUT_PERCENTAGE_CAPS = "DefaultRolloutPercentage";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final ObjectMapper CASE_INSENSITIVE_MAPPER = new ObjectMapper().configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
    private final String context;
    private final String label;
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();
    private final AppConfigurationProperties appConfigurationProperties;
    private final HashMap<String, KeyVaultClient> keyVaultClients;
    private final ClientStore clients;
    private final KeyVaultCredentialProvider keyVaultCredentialProvider;
    private final SecretClientBuilderSetup keyVaultClientProvider;
    private final AppConfigurationProviderProperties appProperties;
    private final ConfigStore configStore;

    AppConfigurationPropertySource(String context, ConfigStore configStore, String label, AppConfigurationProperties appConfigurationProperties, ClientStore clients, AppConfigurationProviderProperties appProperties, KeyVaultCredentialProvider keyVaultCredentialProvider, SecretClientBuilderSetup keyVaultClientProvider) {
        super(context + configStore.getEndpoint() + "/" + label);
        this.context = context;
        this.configStore = configStore;
        this.label = label;
        this.appConfigurationProperties = appConfigurationProperties;
        this.appProperties = appProperties;
        this.keyVaultClients = new HashMap();
        this.clients = clients;
        this.keyVaultCredentialProvider = keyVaultCredentialProvider;
        this.keyVaultClientProvider = keyVaultClientProvider;
    }

    private static List<Object> convertToListOrEmptyList(LinkedHashMap<String, Object> parameters, String key) {
        List listObjects = (List)CASE_INSENSITIVE_MAPPER.convertValue(parameters.get(key), (TypeReference)new TypeReference<List<Object>>(){});
        return listObjects == null ? Collections.emptyList() : listObjects;
    }

    public String[] getPropertyNames() {
        Set<String> keySet = this.properties.keySet();
        return keySet.toArray(new String[keySet.size()]);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    FeatureSet initProperties(FeatureSet featureSet) throws IOException {
        String storeName = this.configStore.getEndpoint();
        Date date = new Date();
        SettingSelector settingSelector = new SettingSelector().setLabelFilter(this.label);
        settingSelector.setKeyFilter(this.context + "*");
        List<ConfigurationSetting> settings = this.clients.listSettings(settingSelector, storeName);
        List<ConfigurationSetting> features = new ArrayList<ConfigurationSetting>();
        if (this.configStore.getFeatureFlags().getEnabled().booleanValue()) {
            settingSelector.setKeyFilter(this.configStore.getFeatureFlags().getKeyFilter()).setLabelFilter(this.configStore.getFeatureFlags().getLabelFilter());
            features = this.clients.listSettings(settingSelector, storeName);
            if (features == null) {
                throw new IOException("Unable to load properties from App Configuration Store.");
            }
        }
        if (settings == null) {
            throw new IOException("Unable to load properties from App Configuration Store.");
        }
        for (ConfigurationSetting setting : settings) {
            String key = setting.getKey().trim().substring(this.context.length()).replace('/', '.');
            if (setting.getContentType() != null && setting.getContentType().equals("application/vnd.microsoft.appconfig.keyvaultref+json;charset=utf-8")) {
                String entry = this.getKeyVaultEntry(setting.getValue());
                if (entry == null) continue;
                this.properties.put(key, entry);
                continue;
            }
            if (StringUtils.hasText((String)setting.getContentType()) && JsonConfigurationParser.isJsonContentType(setting.getContentType())) {
                HashMap<String, Object> jsonSettings = JsonConfigurationParser.parseJsonSetting(setting);
                for (Map.Entry<String, Object> jsonSetting : jsonSettings.entrySet()) {
                    key = jsonSetting.getKey().trim().substring(this.context.length());
                    this.properties.put(key, jsonSetting.getValue());
                }
                continue;
            }
            this.properties.put(key, setting.getValue());
        }
        return this.addToFeatureSet(featureSet, features, date);
    }

    private String getKeyVaultEntry(String value) {
        String secretValue = null;
        try {
            KeyVaultSecret secret;
            URI uri = null;
            try {
                JsonNode kvReference = MAPPER.readTree(value);
                uri = new URI(kvReference.at("/uri").asText());
            }
            catch (URISyntaxException e) {
                LOGGER.error("Error Processing Key Vault Entry URI.");
                ReflectionUtils.rethrowRuntimeException((Throwable)e);
            }
            if (!this.keyVaultClients.containsKey(uri.getHost())) {
                KeyVaultClient client = new KeyVaultClient(this.appConfigurationProperties, uri, this.keyVaultCredentialProvider, this.keyVaultClientProvider);
                this.keyVaultClients.put(uri.getHost(), client);
            }
            if ((secret = this.keyVaultClients.get(uri.getHost()).getSecret(uri, this.appProperties.getMaxRetryTime())) == null) {
                throw new IOException("No Key Vault Secret found for Reference.");
            }
            secretValue = secret.getValue();
        }
        catch (IOException | RuntimeException e) {
            LOGGER.error("Error Retreiving Key Vault Entry");
            ReflectionUtils.rethrowRuntimeException((Throwable)e);
        }
        return secretValue;
    }

    void initFeatures(FeatureSet featureSet) {
        ObjectMapper featureMapper = new ObjectMapper();
        featureMapper.setPropertyNamingStrategy(PropertyNamingStrategy.KEBAB_CASE);
        this.properties.put("feature-management.featureManagement", featureMapper.convertValue(featureSet.getFeatureManagement(), LinkedHashMap.class));
    }

    private FeatureSet addToFeatureSet(FeatureSet featureSet, List<ConfigurationSetting> settings, Date date) throws IOException {
        for (ConfigurationSetting setting : settings) {
            Object feature = this.createFeature(setting);
            if (feature == null) continue;
            featureSet.addFeature(setting.getKey().trim().substring(".appconfig.featureflag/".length()), feature);
        }
        return featureSet;
    }

    private Object createFeature(ConfigurationSetting item) throws IOException {
        if (item.getContentType() == null || !item.getContentType().equals("application/vnd.microsoft.appconfig.ff+json;charset=utf-8")) {
            String message = String.format("Found Feature Flag %s with invalid Content Type of %s. Ignoring and continuing to process Feature Flags.", item.getKey(), item.getContentType());
            LOGGER.warn(message);
            return null;
        }
        String key = this.getFeatureSimpleName(item);
        try {
            FeatureManagementItem featureItem = (FeatureManagementItem)MAPPER.readValue(item.getValue(), FeatureManagementItem.class);
            Feature feature = new Feature(key, featureItem);
            HashMap<Integer, FeatureFilterEvaluationContext> featureEnabledFor = feature.getEnabledFor();
            if (featureEnabledFor.size() == 0 && featureItem.getEnabled()) {
                return true;
            }
            if (!featureItem.getEnabled()) {
                return false;
            }
            for (int filter = 0; filter < feature.getEnabledFor().size(); ++filter) {
                FeatureFilterEvaluationContext featureFilterEvaluationContext = featureEnabledFor.get(filter);
                LinkedHashMap parameters = featureFilterEvaluationContext.getParameters();
                if (parameters == null || !featureEnabledFor.get(filter).getName().equals(TARGETING_FILTER)) continue;
                Object audienceObject = parameters.get(AUDIENCE);
                if (audienceObject != null) {
                    parameters = (LinkedHashMap)audienceObject;
                }
                List<Object> users = AppConfigurationPropertySource.convertToListOrEmptyList(parameters, USERS_CAPS);
                List<Object> groupRollouts = AppConfigurationPropertySource.convertToListOrEmptyList(parameters, GROUPS_CAPS);
                this.switchKeyValues(parameters, USERS_CAPS, USERS, this.mapValuesByIndex(users));
                this.switchKeyValues(parameters, GROUPS_CAPS, GROUPS, this.mapValuesByIndex(groupRollouts));
                this.switchKeyValues(parameters, DEFAULT_ROLLOUT_PERCENTAGE_CAPS, DEFAULT_ROLLOUT_PERCENTAGE, parameters.get(DEFAULT_ROLLOUT_PERCENTAGE_CAPS));
                featureFilterEvaluationContext.setParameters(parameters);
                featureEnabledFor.put(filter, featureFilterEvaluationContext);
                feature.setEnabledFor(featureEnabledFor);
            }
            return feature;
        }
        catch (IOException e) {
            throw new IOException("Unabled to parse Feature Management values from Azure.", e);
        }
    }

    private String getFeatureSimpleName(ConfigurationSetting setting) {
        return setting.getKey().trim().substring(".appconfig.featureflag/".length());
    }

    private Map<String, Object> mapValuesByIndex(List<Object> users) {
        return IntStream.range(0, users.size()).boxed().collect(Collectors.toMap(String::valueOf, users::get));
    }

    private void switchKeyValues(Map<String, Object> parameters, String oldKey, String newKey, Object value) {
        parameters.put(newKey, value);
        parameters.remove(oldKey);
    }
}

