/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.config;

import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.data.appconfiguration.models.SettingSelector;
import com.azure.spring.cloud.config.State;
import com.azure.spring.cloud.config.StateHolder;
import com.azure.spring.cloud.config.properties.AppConfigurationProperties;
import com.azure.spring.cloud.config.properties.AppConfigurationStoreMonitoring;
import com.azure.spring.cloud.config.properties.ConfigStore;
import com.azure.spring.cloud.config.properties.FeatureFlagStore;
import com.azure.spring.cloud.config.stores.ClientStore;
import java.time.Duration;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.endpoint.event.RefreshEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Component;

@Component
public class AppConfigurationRefresh
implements ApplicationEventPublisherAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppConfigurationRefresh.class);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final List<ConfigStore> configStores;
    private ApplicationEventPublisher publisher;
    private final ClientStore clientStore;
    private String eventDataInfo;

    public AppConfigurationRefresh(AppConfigurationProperties properties, ClientStore clientStore) {
        this.configStores = properties.getStores();
        this.clientStore = clientStore;
        this.eventDataInfo = "";
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }

    @Async
    public Future<Boolean> refreshConfigurations() {
        return new AsyncResult((Object)this.refreshStores());
    }

    public void expireRefreshInterval(String endpoint) {
        for (ConfigStore configStore : this.configStores) {
            if (!configStore.getEndpoint().equals(endpoint)) continue;
            LOGGER.debug("Expiring refresh interval for " + configStore.getEndpoint());
            StateHolder.expireState(configStore.getEndpoint());
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean refreshStores() {
        boolean didRefresh = false;
        if (this.running.compareAndSet(false, true)) {
            try {
                for (ConfigStore configStore : this.configStores) {
                    if (!configStore.isEnabled()) continue;
                    String endpoint = configStore.getEndpoint();
                    AppConfigurationStoreMonitoring monitor = configStore.getMonitoring();
                    if (StateHolder.getLoadState(endpoint) && monitor.isEnabled() && this.refresh(StateHolder.getState(endpoint), endpoint, monitor.getRefreshInterval())) {
                        didRefresh = true;
                        break;
                    }
                    LOGGER.debug("Skipping configuration refresh check for " + endpoint);
                    FeatureFlagStore featureStore = configStore.getFeatureFlags();
                    if (featureStore.getEnabled().booleanValue() && StateHolder.getLoadStateFeatureFlag(endpoint) && this.refresh(StateHolder.getStateFeatureFlag(endpoint), endpoint, monitor.getFeatureFlagRefreshInterval())) {
                        didRefresh = true;
                        break;
                    }
                    LOGGER.debug("Skipping feature flag refresh check for " + endpoint);
                }
            }
            finally {
                this.running.set(false);
            }
        }
        return didRefresh;
    }

    private boolean refresh(State state, String endpoint, Duration refreshInterval) {
        Date date = new Date();
        if (date.after(state.getNextRefreshCheck())) {
            for (ConfigurationSetting watchKey : state.getWatchKeys()) {
                SettingSelector settingSelector = new SettingSelector().setKeyFilter(watchKey.getKey()).setLabelFilter(watchKey.getLabel());
                ConfigurationSetting watchedKey = this.clientStore.getWatchKey(settingSelector, endpoint);
                String etag = null;
                if (watchedKey != null) {
                    etag = watchedKey.getETag();
                }
                LOGGER.debug(etag + " - " + watchKey.getETag());
                if (etag == null || etag.equals(watchKey.getETag())) continue;
                LOGGER.trace("Some keys in store [{}] matching the key [{}] and label [{}] is updated, will send refresh event.", new Object[]{endpoint, watchKey.getKey(), watchKey.getLabel()});
                this.eventDataInfo = watchKey.getKey();
                LOGGER.info("Configuration Refresh Event triggered by " + this.eventDataInfo);
                RefreshEventData eventData = new RefreshEventData(this.eventDataInfo);
                this.publisher.publishEvent((ApplicationEvent)new RefreshEvent((Object)this, (Object)eventData, eventData.getMessage()));
                return true;
            }
            StateHolder.setState(endpoint, state.getWatchKeys(), refreshInterval);
        }
        return false;
    }

    static class RefreshEventData {
        private static final String MSG_TEMPLATE = "Some keys matching %s has been updated since last check.";
        private final String message;

        RefreshEventData(String prefix) {
            this.message = String.format(MSG_TEMPLATE, prefix);
        }

        public String getMessage() {
            return this.message;
        }
    }
}

