/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.config.pipline.policies;

import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.spring.cloud.config.HostType;
import com.azure.spring.cloud.config.RequestTracingConstants;
import com.azure.spring.cloud.config.RequestType;
import org.apache.commons.lang3.StringUtils;
import reactor.core.publisher.Mono;

public class BaseAppConfigurationPolicy
implements HttpPipelinePolicy {
    private static final String PACKAGE_NAME = BaseAppConfigurationPolicy.class.getPackage().getImplementationTitle();
    public static final String USER_AGENT = String.format("%s/%s", StringUtils.remove((String)PACKAGE_NAME, (String)" "), BaseAppConfigurationPolicy.class.getPackage().getImplementationVersion());
    static Boolean watchRequests = false;

    private static String getTracingInfo(HttpRequest request) {
        String track = System.getenv(RequestTracingConstants.REQUEST_TRACING_DISABLED_ENVIRONMENT_VARIABLE.toString());
        if (track != null && track.equalsIgnoreCase("false")) {
            return "";
        }
        String requestTypeValue = RequestType.WATCH.toString();
        if (!watchRequests.booleanValue()) {
            String string = requestTypeValue = request.getUrl().getPath().startsWith("/kv") ? RequestType.STARTUP.toString() : RequestType.WATCH.toString();
        }
        if (requestTypeValue.equals(RequestType.WATCH.toString())) {
            watchRequests = true;
        }
        String tracingInfo = RequestTracingConstants.REQUEST_TYPE_KEY.toString() + "=" + requestTypeValue;
        String hostType = BaseAppConfigurationPolicy.getHostType();
        if (!hostType.isEmpty()) {
            tracingInfo = tracingInfo + "," + (Object)((Object)RequestTracingConstants.HOST_TYPE_KEY) + "=" + BaseAppConfigurationPolicy.getHostType();
        }
        return tracingInfo;
    }

    private static String getHostType() {
        HostType hostType = HostType.UNIDENTIFIED;
        if (System.getenv(RequestTracingConstants.AZURE_FUNCTIONS_ENVIRONMENT_VARIABLE.toString()) != null) {
            hostType = HostType.AZURE_FUNCTION;
        } else if (System.getenv(RequestTracingConstants.AZURE_WEB_APP_ENVIRONMENT_VARIABLE.toString()) != null) {
            hostType = HostType.AZURE_WEB_APP;
        } else if (System.getenv(RequestTracingConstants.KUBERNETES_ENVIRONMENT_VARIABLE.toString()) != null) {
            hostType = HostType.KUBERNETES;
        }
        return hostType.toString();
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        String sdkUserAgent = context.getHttpRequest().getHeaders().get("User-Agent").getValue();
        context.getHttpRequest().getHeaders().put("User-Agent", USER_AGENT + " " + sdkUserAgent);
        context.getHttpRequest().getHeaders().put(RequestTracingConstants.CORRELATION_CONTEXT_HEADER.toString(), BaseAppConfigurationPolicy.getTracingInfo(context.getHttpRequest()));
        return next.process();
    }
}

