/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.config.properties;

import java.util.Date;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.validation.annotation.Validated;

@Configuration
@Validated
@PropertySource(value={"classpath:appConfiguration.yaml"})
@ConfigurationProperties(prefix="spring.cloud.appconfiguration")
public class AppConfigurationProviderProperties {
    public static final String CONFIG_PREFIX = "spring.cloud.appconfiguration";
    private static final Date startDate = new Date();
    @NotEmpty
    @Value(value="${version:1.0}")
    private String version;
    @NotNull
    @Value(value="${maxRetries:2}")
    private int maxRetries;
    @NotNull
    @Value(value="${maxRetryTime:60}")
    private int maxRetryTime;
    @NotNull
    @Value(value="${prekillTime:5}")
    private int prekillTime;

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String apiVersion) {
        this.version = apiVersion;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public int getMaxRetryTime() {
        return this.maxRetryTime;
    }

    public void setMaxRetryTime(int maxRetryTime) {
        this.maxRetryTime = maxRetryTime;
    }

    public int getPrekillTime() {
        return this.prekillTime;
    }

    public void setPrekillTime(int prekillTime) {
        this.prekillTime = prekillTime;
    }

    public Date getStartDate() {
        return new Date(startDate.getTime());
    }
}

