/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.config.properties;

import com.azure.spring.cloud.config.properties.AppConfigurationStoreMonitoring;
import com.azure.spring.cloud.config.properties.FeatureFlagStore;
import com.azure.spring.cloud.config.resource.Connection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ConfigStore {
    private static final String EMPTY_LABEL = "\u0000";
    private static final String[] EMPTY_LABEL_ARRAY = new String[]{"\u0000"};
    private String endpoint;
    private String connectionString;
    @Nullable
    private String label = null;
    private boolean failFast = true;
    private FeatureFlagStore featureFlags = new FeatureFlagStore();
    private boolean enabled = true;
    private AppConfigurationStoreMonitoring monitoring = new AppConfigurationStoreMonitoring();

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public AppConfigurationStoreMonitoring getMonitoring() {
        return this.monitoring;
    }

    public void setMonitoring(AppConfigurationStoreMonitoring monitoring) {
        this.monitoring = monitoring;
    }

    public FeatureFlagStore getFeatureFlags() {
        return this.featureFlags;
    }

    public void setFeatureFlags(FeatureFlagStore featureFlags) {
        this.featureFlags = featureFlags;
    }

    @PostConstruct
    public void validateAndInit() {
        if (StringUtils.hasText((String)this.label)) {
            Assert.isTrue((!this.label.contains("*") ? 1 : 0) != 0, (String)"Label must not contain asterisk(*).");
        }
        if (StringUtils.hasText((String)this.connectionString)) {
            String endpoint = new Connection(this.connectionString).getEndpoint();
            try {
                new URI(endpoint);
                this.endpoint = endpoint;
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("Endpoint in connection string is not a valid URI.", e);
            }
        }
        this.monitoring.validateAndInit();
    }

    public String[] getLabels(List<String> profiles) {
        if (this.getLabel() == null && profiles.size() > 0) {
            Collections.reverse(profiles);
            return profiles.toArray(new String[profiles.size()]);
        }
        if (!StringUtils.hasText((String)this.getLabel())) {
            return EMPTY_LABEL_ARRAY;
        }
        List<String> labels = Arrays.stream(this.getLabel().split(",")).map(label -> this.mapLabel((String)label)).distinct().collect(Collectors.toList());
        if (this.getLabel().endsWith(",")) {
            labels.add(EMPTY_LABEL);
        }
        Collections.reverse(labels);
        if (labels.isEmpty()) {
            return EMPTY_LABEL_ARRAY;
        }
        String[] t = new String[labels.size()];
        return labels.toArray(t);
    }

    private String mapLabel(String label) {
        if (label == null || label.equals("")) {
            return EMPTY_LABEL;
        }
        return label.trim();
    }
}

