/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.config.resource;

import com.azure.spring.cloud.config.resource.Connection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ConnectionPool {
    private final Map<String, Connection> connectionStringMap = new ConcurrentHashMap<String, Connection>();

    public void put(String endpoint, Connection connectionString) {
        Assert.hasText((String)endpoint, (String)"Config store endpoint cannot be null or empty.");
        Assert.notNull((Object)connectionString, (String)"Connection string should not be null.");
        this.connectionStringMap.put(endpoint, connectionString);
    }

    public void put(String endpoint, String connectionString) {
        this.put(endpoint, new Connection(connectionString));
    }

    @Nullable
    public Connection get(String endpoint) {
        return this.connectionStringMap.get(endpoint);
    }

    public Map<String, Connection> getAll() {
        return this.connectionStringMap;
    }
}

