/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.config.stores;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.policy.ExponentialBackoff;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.RetryStrategy;
import com.azure.core.http.rest.PagedResponse;
import com.azure.data.appconfiguration.ConfigurationAsyncClient;
import com.azure.data.appconfiguration.ConfigurationClientBuilder;
import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.data.appconfiguration.models.SettingSelector;
import com.azure.identity.ManagedIdentityCredentialBuilder;
import com.azure.spring.cloud.config.AppConfigurationCredentialProvider;
import com.azure.spring.cloud.config.ConfigurationClientBuilderSetup;
import com.azure.spring.cloud.config.pipline.policies.BaseAppConfigurationPolicy;
import com.azure.spring.cloud.config.properties.AppConfigurationProviderProperties;
import com.azure.spring.cloud.config.resource.Connection;
import com.azure.spring.cloud.config.resource.ConnectionPool;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class ClientStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientStore.class);
    private final AppConfigurationProviderProperties appProperties;
    private final ConnectionPool pool;
    private final AppConfigurationCredentialProvider tokenCredentialProvider;
    private final ConfigurationClientBuilderSetup clientProvider;
    private final HashMap<String, ConfigurationAsyncClient> clients;

    public ClientStore(AppConfigurationProviderProperties appProperties, ConnectionPool pool, AppConfigurationCredentialProvider tokenCredentialProvider, ConfigurationClientBuilderSetup clientProvider) {
        this.appProperties = appProperties;
        this.pool = pool;
        this.tokenCredentialProvider = tokenCredentialProvider;
        this.clientProvider = clientProvider;
        this.clients = new HashMap();
    }

    private ConfigurationAsyncClient getClient(String store) throws IllegalArgumentException {
        if (this.clients.containsKey(store)) {
            return this.clients.get(store);
        }
        ExponentialBackoff retryPolicy = new ExponentialBackoff(this.appProperties.getMaxRetries(), Duration.ofMillis(800L), Duration.ofSeconds(8L));
        ConfigurationClientBuilder builder = this.getBuilder().addPolicy((HttpPipelinePolicy)new BaseAppConfigurationPolicy()).retryPolicy((HttpPipelinePolicy)new RetryPolicy((RetryStrategy)retryPolicy));
        TokenCredential tokenCredential = null;
        Connection connection = this.pool.get(store);
        String endpoint = Optional.ofNullable(connection).map(Connection::getEndpoint).orElse(null);
        if (this.tokenCredentialProvider != null) {
            tokenCredential = this.tokenCredentialProvider.getAppConfigCredential(endpoint);
        }
        String clientId = Optional.ofNullable(connection).map(Connection::getClientId).orElse(null);
        boolean clientIdIsPresent = StringUtils.isNotEmpty((CharSequence)clientId);
        boolean tokenCredentialIsPresent = tokenCredential != null;
        boolean connectionStringIsPresent = Optional.ofNullable(connection).map(Connection::getConnectionString).filter(StringUtils::isNotEmpty).isPresent();
        boolean endPointIsPresent = Optional.ofNullable(connection).map(Connection::getEndpoint).filter(StringUtils::isNotEmpty).isPresent();
        if ((tokenCredentialIsPresent || clientIdIsPresent) && connectionStringIsPresent) {
            throw new IllegalArgumentException("More than 1 Conncetion method was set for connecting to App Configuration.");
        }
        if (tokenCredential != null && clientIdIsPresent) {
            throw new IllegalArgumentException("More than 1 Conncetion method was set for connecting to App Configuration.");
        }
        if (tokenCredential != null) {
            LOGGER.debug("Connecting to " + endpoint + " using AppConfigurationCredentialProvider.");
            builder.credential(tokenCredential);
        } else if (clientIdIsPresent && endPointIsPresent) {
            LOGGER.debug("Connecting to " + endpoint + " using Client ID from configuration file.");
            ManagedIdentityCredentialBuilder micBuilder = new ManagedIdentityCredentialBuilder().clientId(clientId);
            builder.credential((TokenCredential)micBuilder.build());
        } else if (connectionStringIsPresent) {
            LOGGER.debug("Connecting to " + endpoint + " using Connecting String.");
            builder.connectionString(connection.getConnectionString());
        } else if (endPointIsPresent) {
            LOGGER.debug("Connecting to " + endpoint + " using Azure System Assigned Identity or Azure User Assigned Identity.");
            ManagedIdentityCredentialBuilder micBuilder = new ManagedIdentityCredentialBuilder();
            builder.credential((TokenCredential)micBuilder.build());
        } else {
            throw new IllegalArgumentException("No Configuration method was set for connecting to App Configuration");
        }
        builder.endpoint(endpoint);
        if (this.clientProvider != null) {
            this.clientProvider.setup(builder, endpoint);
        }
        this.clients.put(store, builder.buildAsyncClient());
        return this.clients.get(store);
    }

    public final ConfigurationSetting getWatchKey(SettingSelector settingSelector, String storeName) {
        PagedResponse watchedKey = null;
        ConfigurationAsyncClient client = this.getClient(storeName);
        for (int retryCount = 0; retryCount <= this.appProperties.getMaxRetries(); ++retryCount) {
            watchedKey = (PagedResponse)client.listConfigurationSettings(settingSelector).byPage(100).blockFirst();
            if (watchedKey != null && watchedKey.getStatusCode() == HttpStatus.TOO_MANY_REQUESTS.value()) {
                HttpHeader retryAfterHeader = watchedKey.getHeaders().get("retry-after-ms");
                if (retryAfterHeader != null) {
                    try {
                        Integer retryAfter = Integer.valueOf(retryAfterHeader.getValue());
                        Thread.sleep(retryAfter.intValue());
                    }
                    catch (NumberFormatException e) {
                        LOGGER.warn("Unable to parse Retry After value.", (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        LOGGER.warn("Failed to wait after getting 429.", (Throwable)e);
                    }
                }
            } else {
                if (watchedKey != null && watchedKey.getValue().size() > 0) {
                    return (ConfigurationSetting)watchedKey.getValue().get(0);
                }
                return null;
            }
            watchedKey = null;
        }
        return null;
    }

    public final List<ConfigurationSetting> listSettings(SettingSelector settingSelector, String storeName) {
        ConfigurationAsyncClient client = this.getClient(storeName);
        return (List)client.listConfigurationSettings(settingSelector).collectList().block();
    }

    ConfigurationClientBuilder getBuilder() {
        return new ConfigurationClientBuilder();
    }
}

